/*
Arduino-MAX30100 oximetry / heart rate integrated sensor library
Copyright (C) 2016  OXullo Intersecans <x@brainrapers.org>
This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "MAX30100_PulseOximeter.h"

//#define REPORTING_PERIOD_MS     1000

Serial pc(USBTX, USBRX);
Timer t;

// PulseOximeter is the higher level interface to the sensor
// it offers:
//  * beat detection reporting
//  * heart rate calculation
//  * SpO2 (oxidation level) calculation
PulseOximeter pox;

uint32_t tsLastReport = 0;

// Callback (registered below) fired when a pulse is detected

void onBeatDetected()
{
 //   pc.printf("Beat!\r\n");
}

bool setup()
{
    pc.baud(115200);
    pc.printf("Start program!\r\n");
    //pox = new PulseOximeter (&pc);
    
    // Initialize the PulseOximeter instance and register a beat-detected callback
    if(!pox.begin())
        return false;
    pox.setOnBeatDetectedCallback(onBeatDetected);
    return true;
}

bool newValueMAX30100 = 0;
float heartRate;
float finalHeartRate;
uint8_t sp02;
uint16_t finalSp02;
uint32_t REPORTING_PERIOD_MS = 1000;
std::vector<float> valuesHeartRate;
std::vector<uint8_t> valuesSp02;
uint8_t samplesMAX30100 = 10;
uint8_t counterMAX30100 = 0;;

void updateMAX30100 (){
    // Make sure to call update as fast as possible
    pox.update();
    
    if (t.read_ms() > REPORTING_PERIOD_MS) {
        heartRate = pox.getHeartRate();
        sp02 = pox.getSpO2();
        
        if(heartRate != 0 && sp02 != 0) {
            pc.printf("Heart rate: %f",heartRate);
            pc.printf("   bpm / SpO2: %d%\r\n",sp02);
            valuesHeartRate.push_back(heartRate);
            valuesSp02.push_back(sp02);
            counterMAX30100 ++;
        }else{
            pc.printf("No finger\r\n");
        }
        
        if(samplesMAX30100 == counterMAX30100) {
            
            finalHeartRate = 0;
            finalSp02 = 0;
            for(int i=0; i<samplesMAX30100; i++){
                finalHeartRate += valuesHeartRate[i];
                finalSp02 += valuesSp02[i];        
            }
            
            finalHeartRate /= samplesMAX30100;
            finalSp02 /= samplesMAX30100;
            
            counterMAX30100 = 0;
            valuesHeartRate.clear();
            valuesSp02.clear();
            newValueMAX30100 = true;
        }
        
        t.reset();
    }         
}

void loop()
{
    updateMAX30100();
    
    if(newValueMAX30100){
        pc.printf("--->New Value\r\n");
        pc.printf("Heart rate: %f",finalHeartRate);
        pc.printf("   bpm / SpO2: %d%\r\n",finalSp02);
        pc.printf("*************************\r\n");
        newValueMAX30100 = false;  
    }
       
}

int main()
{
    if(setup())
        pc.printf("MAX30100 beginning\r\n");
    else
        return 0;
    
    t.start();    
    while(1)
        loop();   
}