/* BlinkLed.h */
#ifndef BLINKLED_H_
#define BLINKLED_H_

#include "mbed.h"
#include "rtos.h"

/** LED which blinks automatically with RTOS
*/
class BlinkLed
{
public:
    /** Constructor
     */
    BlinkLed(PinName, int);
    
    /** Destructor
     */
    ~BlinkLed();
    
    /** Start biinking
     */
    void startBlink();
      
private:   
    /** Function for blinking
     *  This function will be bind to new thread
     */
    static void blink(void const *argument);
    
    /** Target Led
     */
    DigitalOut led;
    
    /** Blink time
     */
    int n;
    
    /** Pointer to thread for blinking
     */
    Thread* thread;
};

#endif /* BLINKLED_H_ */
