/*----------------------------------------------------------
20130824:Todos:improve the performance of this program.
get only the rssi value.


----------------------------------------------------------*/

#include "XBeeGetRssi.h"
#include "mbed.h"
//#include <string.h>


XBeeGetRssi::XBeeGetRssi(PinName tx,PinName rx){
    _tx=tx;
    _rx=rx;
}

char* XBeeGetRssi::_getRssi(/*int n*/){
    //int judge_counter=0;
    int judge_counter=0;
    int rssi_counter=2;
    //int xbee_message_counter=0;
    
    Serial pc(USBTX,USBRX); //for debugging.
    Serial _MyXbee(_tx,_rx);
    
    _rssi[0]='0';
    _rssi[1]='0';
    
    for(int i=2;i<20;i++){
        _rssi[i]='0'; //initial value
    }
    
    _MyXbee.putc('T');
    
    wait(1.0);
    _MyXbee.putc('+');
    wait_ms(1);
    _MyXbee.putc('+');
    wait_ms(1);
    _MyXbee.putc('+');
    wait_ms(1);

    //judge_counter=0; //reset counter for later use

    wait(1.0);
    
    _MyXbee.putc('A');
    wait_ms(5);
    _MyXbee.putc('T');
    wait_ms(10);
    _MyXbee.putc('D');
    wait_ms(10);
    _MyXbee.putc('B');
    wait_ms(10);
    _MyXbee.putc('\r');
    wait_ms(10);
    
    while(_rssi[judge_counter++]!='\0'){
        while(_MyXbee.readable()){
            _rssi[rssi_counter++]=_MyXbee.getc();
        }
    }
    if(_rssi[5]=='T'){
        _rssi_address=&_rssi[9];
    }else{
        _rssi_address=&_rssi[0];
    }
    
    _MyXbee.putc('A');
    wait_ms(5);
    _MyXbee.putc('T');
    wait_ms(5);
    _MyXbee.putc('C');
    wait_ms(5);
    _MyXbee.putc('N');
    wait_ms(5);
    _MyXbee.putc('\r');
    
    return _rssi_address;
    
}

int XBeeGetRssi::getRssi(/*int n*/){
    int _rssi_value=0;
    _returned_rssi=_getRssi();
    
    switch(*_returned_rssi){
        case '0':
            _rssi_value+=0;
            break;
        case '1':
            _rssi_value+=(int)(*_returned_rssi-0x30)*16;
            break;
        case '2':
            _rssi_value+=(int)(*_returned_rssi-0x30)*16;
            break;
        case '3':
            _rssi_value+=(int)(*_returned_rssi-0x30)*16;
            break;
        case '4':
            _rssi_value+=(int)(*_returned_rssi-0x30)*16;
            break;
        case '5':
            _rssi_value+=(int)(*_returned_rssi-0x30)*16;
            break;
        case '6':
            _rssi_value+=(int)(*_returned_rssi-0x30)*16;
            break;
        case '7':
            _rssi_value+=(int)(*_returned_rssi-0x30)*16;
            break;
        case '8':
            _rssi_value+=(int)(*_returned_rssi-0x30)*16;
            break;
        case '9':
            _rssi_value+=(int)(*_returned_rssi-0x30)*16;
            break;
        case 'A':
            _rssi_value+=(int)(*_returned_rssi-0x31)*16;
            break;
        case 'B':
            _rssi_value+=(int)(*_returned_rssi-0x31)*16;
            break;
        case 'C':
            _rssi_value+=(int)(*_returned_rssi-0x31)*16;
            break;
        case 'D':
            _rssi_value+=(int)(*_returned_rssi-0x31)*16;
            break;
        case 'E':
            _rssi_value+=(int)(*_returned_rssi-0x31)*16;
            break;
        case 'F':
            _rssi_value+=(int)(*_returned_rssi-0x31)*16;
            break;
        default:
            _rssi_value+=0;
            break;
    }
    switch(*(_returned_rssi+1)){
        case '0':
            _rssi_value+=0;
            break;
        case '1':
            _rssi_value+=(int)(*(_returned_rssi+1)-0x30);
            break;
        case '2':
            _rssi_value+=(int)(*(_returned_rssi+1)-0x30);
            break;
        case '3':
            _rssi_value+=(int)(*(_returned_rssi+1)-0x30);
            break;
        case '4':
            _rssi_value+=(int)(*(_returned_rssi+1)-0x30);
            break;
        case '5':
            _rssi_value+=(int)(*(_returned_rssi+1)-0x30);
            break;
        case '6':
            _rssi_value+=(int)(*(_returned_rssi+1)-0x30);
            break;
        case '7':
            _rssi_value+=(int)(*(_returned_rssi+1)-0x30);
            break;
        case '8':
            _rssi_value+=(int)(*(_returned_rssi+1)-0x30);
            break;
        case '9':
            _rssi_value+=(int)(*(_returned_rssi+1)-0x30);
            break;
        case 'A':
            _rssi_value+=(int)(*(_returned_rssi+1)-0x31);
            break;
        case 'B':
            _rssi_value+=(int)(*(_returned_rssi+1)-0x31);
            break;
        case 'C':
            _rssi_value+=(int)(*(_returned_rssi+1)-0x31);
            break;
        case 'D':
            _rssi_value+=(int)(*(_returned_rssi+1)-0x31);
            break;
        case 'E':
            _rssi_value+=(int)(*(_returned_rssi+1)-0x31);
            break;
        case 'F':
            _rssi_value+=(int)(*(_returned_rssi+1)-0x31);
            break;
        default:
            _rssi_value+=0;
            break;
    }
    
    return -1*_rssi_value;
}