#include "MU2Class.h"
#include "mbed.h"

MU2Class::MU2Class(PinName tx,PinName rx){
    _tx=tx;
    _rx=rx;
}

/*MU2Class::MU2Class(PinName tx,PinName rx) : Serial(tx,rx){
}*/

uint8_t MU2Class::Store_Str(char data_str[], int index, char Message[]){
  uint8_t j=0;
  while(Message[j]!='\0'&&Message[j]!='^')  data_str[index++]=Message[j++];//store char in message into data_str and returns the last index.
  return index;
}

void MU2Class::send(char Send_Message[]){
  Serial MyMu2(_tx,_rx);
  //Serial pc(USBTX,USBRX);
  
  int i=4, str_length=0,send_index=0;
  char send_data[255];
  
  MyMu2.baud(19200);
  //pc.baud(19200);

  send_index=0;//initializing the variant.
  send_index=Store_Str(send_data, send_index, "@DT00^");//this variant is the last index of the string.The reason why char "^" here is that for the case of the data size 10,20,A0 or something . Store_Str copies the string of its last variant into its first variant .

  while(Send_Message[str_length]!='\0'){
    send_data[send_index++]=Send_Message[str_length++];//storing the string we wanna send into the send_data until null terminater appers.
  }
  //send_data[send_index++]='\r';//insert carrige return at the last of send_data.
  //send_data[send_index++]='\n';
  send_data[send_index++]='\0';

  str_length-=2; //the code block below is for making data size proper.

  for(i=4; i>2; i--){
    if(str_length%16<10){
      send_data[i]='0'+str_length%16;
    }else{
      switch(str_length%16){
        case 10:send_data[i]='A'; break;
        case 11:send_data[i]='B'; break;
        case 12:send_data[i]='C'; break;
        case 13:send_data[i]='D'; break;
        case 14:send_data[i]='E'; break;
        case 15:send_data[i]='F'; break;
      }
    }
    str_length/=16;
  }
  MyMu2.printf(send_data);
  /*for(int j=0;j<=send_index;j++){
    MyMu2.putc(send_data[j]);
    pc.putc(send_data[j]); //for debugging.Comment out when U use this in practice.
  }*/
}