
/******************************************************************************
 * Low level infrared transmission
 * This library provides a low level interface to send IR commands. in principle
 * other higher level IR type remotes could be build on top of this. I wrote
 * this code to send IR commands to a Nikon camera, which it works rather well
 * for. 
 *
 * Copyright (C) 2010 Ali Saidi
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
 
 #include "TxIR.hpp"
 

void
TxIR::doAction()
{
    if (pos >= len) {
        delete [] data;
        _inUse = false;
        txPin.write(0);
        return;
    }
        
    delay.attach_us(this, &TxIR::doAction, data[pos++]);
    if (high)
        txPin.write(0);
    else
        txPin.write(0.5);
   high = !high;
}

bool
TxIR::txSeq(unsigned freq, unsigned _len, const unsigned *_data) 
{
    // @todo a lock or semaphore should be used here
    if (inUse())
        return false;
    _inUse = true;
    
    // keep a copy of the data, so it can't change
    len = _len;
    data = new unsigned[len];
    memcpy(data, _data, len * sizeof(unsigned));
    pos = 0;
    
    // setup the PWM
    txPin.write(0.0);
    txPin.period_us(freq);
    
    // Get the interrupt ready
    delay.detach();
    high = true;
    delay.attach_us(this, &TxIR::doAction, data[pos++]);
    
    // Begin
    txPin.write(0.5);
    
    return true;
}
