#include "mbed.h"
#include "HIDScope.h"
#include "QEI.h"
#include "iostream"
#include "MODSERIAL.h"

//Leds
DigitalOut ledb(LED_BLUE);
DigitalOut ledr(LED_RED);
DigitalOut ledg(LED_GREEN);

//Motor
DigitalOut motor1DC(D7);
PwmOut motor1PWM(D6);

//Button
DigitalIn   button1(SW2);

// HIDscope
HIDScope scope(1);

//Ticker
Ticker tick;
float R = 3;
float F = 0.01;
int counter=0;

// Encoder
float X = 32.0;
float N = 131.0;
float pulse_count;
float angle_motor;
QEI Encoder(D8,D9,NC,N);
MODSERIAL pc(USBTX,USBRX);

// Send angle to HIDScope and pc function
void Calculate()
{
    // Get number of pulses and calculate angle
    pulse_count = Encoder.getPulses();
    float angle_pp =360/(X * N);
    float angle = pulse_count*angle_pp;

    // Send angle to HIDScope
    scope.set(0, angle);
    scope.send();
    
    //Increase counter after measurement
    counter++;
    
    // Turn motor off and reset encoder if desired rotating time has been reached
    // Number of measurements required to reach the desired number of rotations = Rotations / Measurement Frequency = (R/F) 
    if(counter==R/F)
    {
        motor1PWM = 0; // motor off
    }  
}

void Measure()
{
    tick.attach(&Calculate, F);
}

// Roll function
void Roll()
{ 
    // Show rolling state through leds
    ledg = 1; // green led off
    ledb = 1; // blue led off
    ledr = 0; // red led on = rolling

    // Turn motor on
    motor1PWM = 1; // motor on
    
    // Reset counter and start measuring
    Encoder.reset();
    counter = 0;
    Measure(); 
}

int main()
{
    // Initialize system
    pc.baud(9600);
    motor1DC = -1;
    ledb = 1;
    ledr = 1;
    ledg = 0;
    Encoder.reset();
    
    // Dice roll code
    while(true){      
        // Roll dice if switch2 on K64F is pressed
        if(button1==0) 
        {
            Encoder.reset();
            Roll();
        }
    }
}