#include "mbed.h"

// Led control outputs
DigitalOut ledb(LED_BLUE);
DigitalOut ledr(LED_RED);
DigitalOut ledg(LED_GREEN);

// Motor control outputs
DigitalOut motor1DC(D7);
PwmOut motor1PWM(D6);

// Input signals. Can either be pressing switch2 or EMG control.
DigitalIn   button1(SW2);
AnalogIn EMGDice(A0);

void Roll()
{  
    ledg = 1; // green led off
    ledr = 0; // red led on = rolling
    
    motor1PWM = 1; // motor on -> roll dice
    wait(1.05);
    motor1PWM = 0; // motor off

    motor1DC = abs(motor1DC-1); // rotate other way next time
    
    ledr = 1; // red led off
    ledb = 0; // blue led on -> inidcates wait time to protect motors
}

int main()
{
    // Initialize system
    motor1DC = 1;
    ledb = 1;
    ledr = 1;
    ledg = 0;
    float t = 1.5; // Wait time (s) between rolls to protect motor
    
    // Dice roll code
    while (true) 
    {
        if(button1==0 or EMGDice>0.8) // Roll dice if switch2 is pressed or EMG input is delivered.
        { 
            Roll();
            wait(t); // wait before next roll to protect motors
            ledb = 1; 
            ledg = 0; // green led on = ready to roll
        }     
          
    }
}