#ifndef _GLOBAL_H_
#define _GLOBAL_H_

#include "UartReceiver.h"
#include "CommandParser.h"
#include "TimeManager.h"
#include "SDDataStore.h"
#include "DeviceRepeater.h"

/* DEBUG = ON/OFF */
#define _DEBUG_PRINTF_

/*********************************************/
/* Controllors  */
/*********************************************/
extern TimeManager *pTM;
extern CommandParser *pCP;
extern UartReceiver *pUR;
extern SDDataStore *pSds;
extern DeviceRepeater *pDevRept;

/*********************************************/
/* Drivers  */
/*********************************************/
/* define command rules */
extern CmdParseRule rules[];
extern int getNumOfRules;

/*********************************************/
/* Debugging  */
/*********************************************/
#ifdef _DEBUG_PRINTF_
extern Serial dbg;
extern Serial uartStream;
extern bool uartOn;
#endif /* _DEBUG_PRINTF_ */

#ifdef _DEBUG_PRINTF_
#define dbgprintf(f_, ...) dbg.printf((f_), ##__VA_ARGS__)
#else
#define dbgprintf(f_, ...) while(0){}
#endif /* _DEBUG_PRINTF_ */
#define uprintf(f_, ...) while(uartOn){uartStream.printf((f_), ##__VA_ARGS__);break;}

#endif /* _GLOBAL_H_ */