#ifndef _SDDATASTORE_H_
#define _SDDATASTORE_H_

#include "SDFileSystem.h"
#include "TimeManager.h"

class SDDataStore
{
public:
    const static int MaxPathLength = 256;        
private:    
    SDFileSystem *pS;
    TimeManager *pT;
    FILE *fpCurrent;
    char fnameCurrent[MaxPathLength];
private:
    /* (INVALIDED) constructor */
    SDDataStore(void);
public:
    /* constructor, pSD, TimeManager */
    SDDataStore(TimeManager *pSetTM);
    /* destructor */
    ~SDDataStore();
    /* for Sensing and Logging generate (prefix)TimeStampFile.(ext)*/
    bool startFileWithTimeStamp(char *prefix, char *ext);
    /* checkFileExist, false=NOT-EXIST, true=EXIST */
    bool checkFileExist(char *fname);
    /* removeFile, false=NOT-EXIST, true=EXIST */
    void removeFile(char *fname);
    /* open file at WriteMode FALSE=ERR, TRUE=OK */
    bool openFile(char *fname);
    /* get FileName of open file */
    char *getFileName(void);
    /* get current file pointer  */
    FILE *getFilePointer(void);
    /* close file with this Class  */
    void syncFile(void);
    /* close file with this Class  */
    void closeFile(void);
    
private:
    void pathTermination(char *pathArray);
};

#endif /* _SDDATASTORE_H_ */