#include "SDDataStore.h"
#include "global.h"

/* constructor, pSD, TimeManager */
SDDataStore::SDDataStore(TimeManager *pSetTM)
{
    //pS = new SDFileSystem(PC_12, PC_11, PC_10, D4, "sd"); // MOSI, MISO, SCK, CS;
    pS = new SDFileSystem(PC_12, PC_11, PC_10, PD_2, "sd"); // MOSI, MISO, SCK, CS;
    pT = pSetTM;
    fpCurrent = NULL;
    fnameCurrent[0] = '\0';
}

/* destructor */
SDDataStore::~SDDataStore()
{
    closeFile();
}
    
/* for Sensing and Logging generate (prefix)TimeStampFile.(ext)*/
bool SDDataStore::startFileWithTimeStamp(char *prefix, char *ext)
{
    char timeStamp[TimeManager::TimeStampLength + 1] = {0};
    char fname[MaxPathLength] = {0};
    pT->getTimeStamp(timeStamp);
    sprintf(fname, "%s%s.%s", prefix, timeStamp, ext);
    if (this->checkFileExist(fname) == true) {
        this->removeFile(fname);
    }
    if (this->openFile(fname) != true) {
        return false;
    }
    return true;
}
    
/* checkFileExist, false=NOT-EXIST, true=EXIST */
bool SDDataStore::checkFileExist(char *fname)
{
    FILE *fp;
    char filePath[MaxPathLength];
    sprintf(filePath, "/sd/%s", fname);
    pathTermination(filePath);        
    fp = fopen(filePath, "r");
    if (fp == NULL) {
        return false;
    }
    fclose(fp);
    return true;
}
    
/* removeFile, false=NOT-EXIST, true=EXIST */
void SDDataStore::removeFile(char *fname)
{
    char filePath[MaxPathLength];
    sprintf(filePath, "/sd/%s", fname);
    pathTermination(filePath);
    remove(filePath);
}
    
/* open file at WriteMode FALSE=ERR, TRUE=OK */
bool SDDataStore::openFile(char *fname)
{
    FILE *fp;
    char filePath[MaxPathLength];
    sprintf(filePath, "/sd/%s", fname);
    pathTermination(filePath);
    
    fp = fopen(filePath, "a+");
    if (fp == NULL) {
        return false;
    }
    fpCurrent = fp;
    dbgprintf("SDDataStore::openFile(%p) as %s\n", fpCurrent, filePath);
    sprintf(fnameCurrent, "%s", fname);
    return true;
}

/* get FileName of open file */
char *SDDataStore::getFileName(void)
{
    return fnameCurrent;
}

/* get current file pointer  */
FILE *SDDataStore::getFilePointer(void)
{
    return fpCurrent;
}
    
/* close file with this Class  */
void SDDataStore::syncFile(void)
{
    FILE *fp;
    char filePath[MaxPathLength];
    sprintf(filePath, "/sd/%s", getFileName());
    
    dbgprintf("SDDataStore::syncFile(%p) as %s\n", fpCurrent, filePath);
    if (fpCurrent != NULL) {
        /* fflush is not working on SDFileSystem :p */
        fclose(fpCurrent);
        fp = fopen(filePath, "a+");
        if (fp == NULL) {
            dbgprintf("SDDataStore::syncFile(CRITICAL) in fopen\n");
            return;
        }
        fpCurrent = fp;
    }
}

/* close file with this Class  */
void SDDataStore::closeFile(void)
{
    dbgprintf("SDDataStore::closeFile(%p)\n", fpCurrent);
    if (fpCurrent != NULL) {
        fclose(fpCurrent);
        fpCurrent = NULL;
        fnameCurrent[0] = '\0';
    }
}
    
void SDDataStore::pathTermination(char *pathArray)
{
    pathArray[MaxPathLength-1] = '\0';
}    
