#ifndef _TIMEMANAGER_H_
#define _TIMEMANAGER_H_

#include "mbed.h"
#include "string.h"

class TimeManager
{
public:
    /** Opcode for setCurrentTime（YY/MM/DD-HH/mm/SS） */
    class SetTimeMethod {
    public:
        const static int Year   = 0;
        const static int Month  = 1;
        const static int Day    = 2;
        const static int Hour   = 3;
        const static int Min    = 4;
        const static int Sec    = 5;
    };
    static const int TimeStampLength = sizeof("YYYY-MM-DD_HH:MM:SS") - 1;
private:
    /* Tick base class */
    Ticker baseclock;
    /* current time */
    struct tm current;
public:
    /* Constractor */
    TimeManager(void);
    /* tick (currenttime++) */
    void tick(void);
    /* copy Struct Time to arg */
    void getCurrentTime(struct tm *ret);
    /* get string of timestamp */
    int getTimeStamp(char *dst);
    /* set time parameters */
    bool setCurrentTime(int selector, int set);
private:
    /* calcurate Number of Days in month */
    int getDaysInMonth(int month, int year);
};

#endif /* _TIMEMANAGER_H_ */