/** --- Includes --- */
#include "mbed.h"
#include "global.h"
#include "string.h"
#include "DeviceRepeater.h"

void repeater_basetick(void)
{
    pDevRept->tick();
}

DeviceRepeater::DeviceRepeater(int setDeviceID, DeviceDriver *setDriver)
{
    deviceID = setDeviceID;
    pClock = new Ticker();
    selected_id = NOT_ID_SELECTED;
    pDriver = setDriver;
    stat = DEV_NOT_INIT;
    repeat_max_count = DEFAULT_REPEAT_MAX_COUNT;
    repeat_stride_sec = DEFAULT_REPEAT_STRIDE;
    repeat_singleshot = DEFAULT_REPEAT_SINGLESHOT;
}

bool DeviceRepeater::readyToStart(void)
{
    bool ret;
    switch(stat) {
    case DEV_READY:
        ret = true;
        break;
    case DEV_NOT_INIT:
        ret = true;
        break;
    case DEV_RUNNING:
        ret = false;
        break;
    default:
        ret = false;
        break;
    }
    return ret;
}

bool DeviceRepeater::setRepeatCount(int maxcount)
{
    /* never accept in Not Ready To Run */
    if (!this->readyToStart()) {
        return false;
    }
    /* invalid arguments */
    if (maxcount < 0) {
        return false;
    }
    repeat_max_count = maxcount;
    return true;    
}

bool DeviceRepeater::setRepeatStride(int sec)
{
    /* never accept in Not Ready To Run */
    if (!this->readyToStart()) {
        return false;
    }
    /* invalid arguments */
    if (sec < 0) {
        return false;
    } else if (sec == 0) {
        return false;
    }
    repeat_stride_sec = sec;
    return true;
}

bool DeviceRepeater::setRepeatSingleShot(bool setMode)
{
    /* never accept in Not Ready To Run */
    if (!this->readyToStart()) {
        return false;
    }
    /* TODO */
    repeat_singleshot = setMode; 
    return true;
}

bool DeviceRepeater::start(void)
{
    bool ret;
    switch(stat) {
    case DEV_READY:
        break;
    case DEV_NOT_INIT:
        ret = this->init();
        if (ret != true) {
            return false;
        }
        break;
    case DEV_RUNNING:
        return false;
    case DEV_FATAL:
    default:
        return false;
    }
    // Device is in DEV_READY

    /* TODO - add callback for changing READY to RUNNING */
    pDriver->ready2run();
    pSds->syncFile();
    
    // start Runnig
    // Device is in DEV_RUNNING
    stat = DEV_RUNNING;
    repeat_remain_cnt = repeat_max_count;
    repeat_remain_sec = repeat_stride_sec;
    pClock->attach(repeater_basetick, 1.0);
    return true;
}

bool DeviceRepeater::stop(void)
{
    if (stat != DEV_RUNNING) {
        return false;
    }
    
    /* Delaied Stop */
    stat = DEV_REQ_STOP;
    repeat_remain_sec = 0;
    stat = DEV_READY;
    return true;
}

void DeviceRepeater::tick(void)
{
    if (stat != DEV_RUNNING) {
        /* Delaied Stop */
        if (stat == DEV_REQ_STOP) {
            /*****************************************************/
            /* TODO - add callback for changing RUNNING to READY */
            /*****************************************************/
            pDriver->run2ready();
            pSds->syncFile();
            repeat_remain_sec = 0;
            stat = DEV_READY;
            return;
        }        
        return;
    }
    if (repeat_remain_sec > 0) {
        repeat_remain_sec--;
    }
    if (repeat_remain_sec == 0) {
        bool procRun;
        FILE *pSDFile = pSds->getFilePointer();
        /*****************************************************/
        /* TODO - kick Senser and send XFD/XDS Data */
        /*****************************************************/
        /** Sensing and Sending Data **/
        procRun = pDriver->exec(deviceID, pUR->getCurrentUart(), pSDFile);
        pSds->syncFile();
        if (repeat_singleshot) {
            /* Check Exec Sigle On */
            if (procRun == true) {
                /* Already - Executed Mesurement in exec */
                /** GOTO Shutdown */
                /* STOP ticking (0->1) */
                /*****************************************************/
                /* TODO - add callback for changing RUNNING to READY */
                /*****************************************************/
                repeat_remain_cnt = 0;
                pDriver->run2ready();
                pSds->syncFile();
                repeat_remain_sec = 0;
                stat = DEV_READY;
                pClock->detach();
                return;
            } else {
                /* Not Yet - NO Execution in exec */
            }
        }        
    }
    if (repeat_remain_sec <= 0) {
        if (repeat_remain_cnt > 0) {
            repeat_remain_cnt--;
            if (repeat_remain_cnt == 0) {
                /* STOP ticking (0->1) */
                /*****************************************************/
                /* TODO - add callback for changing RUNNING to READY */
                /*****************************************************/
                pDriver->run2ready();
                pSds->syncFile();
                repeat_remain_sec = 0;
                stat = DEV_READY;
                pClock->detach();
                return;
            }
            /* REFILL */
        } else if (repeat_remain_cnt == 0) {
            /* REFILL */
        } else {
            /*****************************************************/
            /* TODO : FATAL */
            /*****************************************************/
            while(1);
        }
        repeat_remain_sec = repeat_stride_sec;
    }
}

bool DeviceRepeater::init(void)
{
    int ret;
    selected_id = NOT_ID_SELECTED;
    ret = pDriver->init();
    if (ret == 0) {
        stat = DEV_READY;
    } else {
        stat = DEV_FATAL;
    }
    return (stat == DEV_READY)? true : false;
}

bool DeviceRepeater::resetAllStatus(void)
{
    /* TODO */
    int ret;
    ret = pDriver->reset();
    if (ret == 0) {
        /* SUCCESS */
        /* TODO */  
    } else {
        /* ERROR */
        /* TODO */
    }
    return false;
}

bool DeviceRepeater::setConfigId(int id)
{
    /* never accept in Not Ready To Run */
    if (!this->readyToStart()) {
        return false;
    }
    if (selected_id != NOT_ID_SELECTED) {
        return false;
    }
    selected_id = id;
    return true;
}

bool DeviceRepeater::setConfigValue(int setValue)
{
    bool ret;
    /* never accept in Not Ready To Run */
    if (!this->readyToStart()) {
        return false;
    }
    /* not set config ID before Set */
    if (selected_id == NOT_ID_SELECTED) {
        return false;
    }
    ret = pDriver->set_config(selected_id, setValue);
    selected_id = NOT_ID_SELECTED;
    return ret;
}

bool DeviceRepeater::getConfigValue(int *retValue)
{
    bool ret;
    /* never accept in Not Ready To Run */
    if (!this->readyToStart()) {
        return false;
    }
    /* not set config ID before Get */
    if (selected_id == NOT_ID_SELECTED) {
        return false;
    }
    ret = pDriver->get_config(selected_id, retValue);
    selected_id = NOT_ID_SELECTED;
    return ret;
}