#ifndef _COMMANDPARSER_H_
#define _COMMANDPARSER_H_

#include "UartReceiver.h"

class CommandParser;

/**
 * Parsing Rules 
 * if (cmdName) CALL func with exarg.
 */
typedef struct _command_parser_rule_s {
    char* cmdName;
    int(*func)(CommandParser*, char*, int);
    int exarg;
} CmdParseRule;

/* CommandParser */
class CommandParser
{
public:
    /* CMD length */
    const static int CmdNameLen = 3;
    /* CMD total length */
    const static int CmdLen = sizeof(":0 CMD 0000") - 1 /* EOL */;
    /* reply code (for ACK/NAK) */
    class NakCode
    {
    public:
        const static int NAK_UNDEFINED = 0000;
        const static int NAK_INVAL_CMD = 1000;
        const static int NAK_INVAL_LEN = 1001;
        const static int NAK_INVAL_FMT = 1002;
        const static int NAK_INVAL_PARAM = 1003;
        const static int NAK_INVAL_SEQ = 1004;
        const static int NAK_IN_RUNNING = 2000;
        const static int NAK_IN_STOPPED = 2010;
        const static int NAK_INTERNAL_ERR = 4000;
    };
private:
    int deviceID;
    UartReceiver *pR;
    Serial *pUart;
    CmdParseRule *ruleTable;
    int ruleTableLen;
private:
    /* (INVALIDED) constructor */
    CommandParser(void);
public:
    /* constructor */
    CommandParser(UartReceiver *setUartReceiver, int setDeviceID,
        CmdParseRule *setRuleTable, int setRuleTableLen);
    /* start parsing */
    void run(void);
    /* process parsing */
    int parse(char *pStr);
    /* get my Device ID */
    int getDeviceID(void);
    /* generate ACK/NAK with int code */
    void reply(bool ack = true, int replyCode = 0);
    /* generate ACK/NAK with String */
    void reply(bool ack, char *replyStr);
    /* get currentUart */
    Serial *getCurrentUart(void);
};
#endif /* _COMMANDPARSER_H_ */