#include "UartReceiver.h"
#include "global.h"

void isrUartRx() {
    pUR->concat();
}

/* Constructor(Accepted) */
UartReceiver::UartReceiver(Serial *pSetUart)
{
    nesthead = 0;
    nesttail = 0;
    tail = 0;
    head = 0;
    pUart = pSetUart;
    pLineHandler = NULL;
}

/* Start Handling */
void UartReceiver::run(void)
{
    pUart->attach(isrUartRx, Serial::RxIrq);
}

/* Stop Handling */
void UartReceiver::stop(void)
{
    pUart->attach(NULL, Serial::RxIrq);
}

/* Update Line Handler Handling */
void* UartReceiver::setLineHandler(void(*setLineHandler)(char*))
{
    void(*prevLineHandler)(char*) = pLineHandler;
    pLineHandler = setLineHandler;
    return (void*)prevLineHandler;
}

/* Export Fixed Buffer Pointer */
char* UartReceiver::dequeue_str(void)
{
    char *ret = NULL;
    if (nesthead != nesttail) {
        ret = &inner_buffer[nesthead][0];
        nesthead++;
        if (nesthead >= RXBUF_NEST) {
            nesthead = 0;
        }
    }
    return ret;
}

/* Recv char from UART and Concat to Liquid Buffer */
void UartReceiver::concat()
{
    char ch;
    int fixed;
    /* connect all buffers */
    while (pUart->readable() != 0) {
        ch = pUart->getc();
        fixed = this->enqueue_ch(ch);
        if (fixed != BufOpen) {
            if (pLineHandler != NULL) {
                (this->pLineHandler)(this->dequeue_str());
            } else {
                uprintf("CALL DEF HANDLER:%s", this->dequeue_str());
            }
        }
    }
}

/* Get Pointer */
Serial *UartReceiver::getCurrentUart(void)
{
    return this->pUart;
}

/* Concat to Liquid Buffer */
/** return UartReceiver::BufFixed, UartReceiver::BufOpen */
int UartReceiver::enqueue_ch(char ch)
{
    int ret = BufOpen;
    inner_buffer[nesttail][tail] = ch;
    if (ch == '\n' || ch == '\r') {
        /** switch buffer */
        inner_buffer[nesttail][tail] = '\0';
        nesttail++;
        tail = 0;
        if (nesttail >= RXBUF_NEST) {
            nesttail = 0;
        }
        ret = BufFixed;
    } else {
        tail++;
        if (tail >= RXBUF_SIZE) {
            /** -- stack overflow --- */
            /** IGNORED **/
            tail = RXBUF_SIZE - 1;
        }
    }
    return ret;
}