#ifndef _UARTRECEIVER_H_
#define _UARTRECEIVER_H_


/** --- Includes --- */
#include "mbed.h"

/** --- Global Structs --- */
class UartReceiver
{
private:
    /** defines */
    static const int RXBUF_SIZE = 64;
    static const int RXBUF_NEST = 4;
    static const int BufOpen    = 0;
    static const int BufFixed   = 1;
public:
    static const int MaxStr = (RXBUF_SIZE - 1);

private:
    /** varialbles */
    Serial *pUart;
    void(*pLineHandler)(char*);
    char inner_buffer[RXBUF_NEST][RXBUF_SIZE];
    int nesthead;
    int nesttail;
    int tail;
    int head;
    
private:
    /* Constructor(CouldNotUse) */
    UartReceiver(void);

public:
    /* Constructor(Accepted) */
    UartReceiver(Serial *pSetUart);
    /* Start Receiving */
    void run(void);
    /* Stop Receiving */
    void stop(void);
    /* set Line Handler */
    void* setLineHandler(void(*setLineHandler)(char*));
    /* Export Fixed Buffer Pointer */
    char* dequeue_str(void);
    /* Recv char from UART and Concat to Liquid Buffer */
    void concat();
    /* Get Pointer */
    Serial *getCurrentUart(void);
private:
    /* Concat to Liquid Buffer */
    /** return UartReceiver::BufFixed, UartReceiver::BufOpen */
    int enqueue_ch(char ch);
};


#endif /* _UARTRECEIVER_H_ */