#ifndef _DEVICEREPEATER_H_
#define _DEVICEREPEATER_H_

#include "DeviceDriverInterface.h"

class DeviceRepeater
{
public:
    typedef enum device_attr_status {
        DEV_FATAL = -2,
        DEV_NOT_INIT = -1,
        DEV_READY = 0,
        DEV_RUNNING,
        DEV_REQ_STOP,
    } DevStatus; 
private:
    static const bool DEFAULT_REPEAT_SINGLESHOT = false;
    static const int DEFAULT_REPEAT_MAX_COUNT = 1;
    static const int DEFAULT_REPEAT_STRIDE = 5;
    static const int NOT_ID_SELECTED = -1;
private:
    int deviceID;
    int selected_id;
    DevStatus stat;
    DeviceDriver *pDriver;
    
    /* Tick base class */
    Ticker *pClock;
    /* members for repeating */
    int repeat_singleshot;
    int repeat_max_count;
    int repeat_stride_sec;
    int repeat_remain_cnt;
    int repeat_remain_sec;
private:
    DeviceRepeater(void);
public:
    DeviceRepeater(int deviceId, DeviceDriver *setDriver);
    bool setRepeatCount(int maxcount);
    bool setRepeatStride(int sec);
    bool setRepeatSingleShot(bool setMode);
    bool setConfigId(int id);
    bool setConfigValue(int setValue);
    bool getConfigValue(int *retValue);
    bool start();
    bool stop();
    bool readyToStart();
    void tick();
    bool resetAllStatus(void);
private:
    bool init();
};

#endif /* _DEVICEREPEATER_H_ */