#include "TimeManager.h"
#include "global.h"


/* Cyclic handler (for tick) */
void flip() {
    pTM->tick();
}

/* Constractor */
TimeManager::TimeManager(void)
{
    current.tm_sec = 0;
    current.tm_min = 0;
    current.tm_hour = 0;
    current.tm_mday = 1;
    current.tm_mon = 1;
    current.tm_year = 0;
    baseclock.attach(flip, 1.0);
}

/* tick (currenttime++) */
void TimeManager::tick(void)
{
    int daysInMonth = getDaysInMonth(current.tm_mon, current.tm_year);
    current.tm_sec++;
    if (current.tm_sec >= 60) {
        current.tm_sec = 0;
        current.tm_min++;
    } else { return; }
    if (current.tm_min >= 60) {
        current.tm_min = 0;
        current.tm_hour++;
    } else { return; }
    if (current.tm_hour >= 24) {
        current.tm_hour = 0;
        current.tm_mday++;
    } else { return; }
    if (current.tm_mday > daysInMonth) {
        current.tm_mday = 0;
        current.tm_mon++;
    } else { return; }
    if (current.tm_mon > 12) {
        current.tm_mon = 1;
        current.tm_year++;
    } else { return; }
}

/* copy Struct Time to arg */
void TimeManager::getCurrentTime(struct tm *ret)
{
    *ret = current;
}

/* get string of timestamp */
int TimeManager::getTimeStamp(char *dst)
{
    char dummy[TimeStampLength + 1];
    sprintf(dummy, "%04d-%02d-%02d_%02d-%02d-%02d",
        current.tm_year + 1900, current.tm_mon, current.tm_mday,
        current.tm_hour, current.tm_min, current.tm_sec);
    memcpy(dst, dummy, TimeStampLength);    
    return TimeStampLength;
}

/* set time parameters */
bool TimeManager::setCurrentTime(int selector, int set)
{
    bool finish = false;
    int daysInMonth = getDaysInMonth(current.tm_mon, current.tm_year);
    dbgprintf("setCurrentTime:%d-%d(%d)\n", selector, set, daysInMonth);
    switch (selector) {
    case SetTimeMethod::Year:
        if (set >= 0) {
            current.tm_year = set;
            finish = true;
        }
        break;
    case SetTimeMethod::Month:
        if (set > 0 && set <= 12) {
            current.tm_mon = set;
            finish = true;
        }
        break;
    case SetTimeMethod::Day:
        if (set > 0 && set <= daysInMonth) {
            current.tm_mday = set;
            finish = true;
        }
        break;
    case SetTimeMethod::Hour:
        if (set >= 0 && set < 24) {
            current.tm_hour = set;
            finish = true;
        }
        break;
    case SetTimeMethod::Min:
        if (set >= 0 && set < 60) {
            current.tm_min = set;
            finish = true;
        }
        break;
    case SetTimeMethod::Sec:
        if (set >= 0 && set < 60) {
            current.tm_sec = set;
            finish = true;
        }
        break;
    };
    return finish;
}

/* calcurate Number of Days in month */
int TimeManager::getDaysInMonth(int month, int year)
{
    int daysInMonth;
    bool leap;
    year += 1900;
    leap = (year % 400 == 0 || (year % 4 == 0 && year % 100 != 0))? true : false;

    if (((month % 2 == 1) && (month <= 7)) ||
        ((month % 2 == 0) && (month >= 8))) {
        /* 31days/month */
        daysInMonth = 31;
    } else if (month == 2) {
        /* 28days OR 29days/month */
        if (leap) {
            daysInMonth = 29;
        } else {
            daysInMonth = 28;
        }
    } else {
        /* 30days/month */
        daysInMonth = 30;
    }
    return daysInMonth;
}