#ifndef _ADXL362_H_
#define _ADXL362_H_
#include "mbed.h"
#include <SPI.h>

// Register Memory Map
#define DEVID_AD        0x00
#define DEVID_MST       0x01
#define PARTID          0x02
#define REVID           0x03
/* _ reserved _ */
#define XDATA           0x08
#define YDATA           0x09
#define ZDATA           0x0A
#define STATUS          0x0B
#define FIFO_ENTRIES_L  0x0C
#define FIFO_ENTRIES_H  0x0D
#define XDATA_L         0x0E
#define XDATA_H         0x0F
#define YDATA_L         0x10
#define YDATA_H         0x11
#define ZDATA_L         0x12
#define ZDATA_H         0x13
#define TEMP_L          0x14
#define TEMP_H          0x15
/* _ reserved _ */
#define SOFT_RESET      0x1F
#define THRESH_ACT_L    0x20
#define THRESH_ACT_H    0x21
#define TIME_ACT        0x22
#define THRESH_INACT_L  0x23
#define THRESH_INACT_H  0x24
#define TIME_INACT_L    0x25
#define TIME_INACT_H    0x26
#define ACT_INACT_CTL   0x27
#define FIFO_CONTROL    0x28
#define FIFO_SAMPLES    0x29
#define INTMAP1         0x2A
#define INTMAP2         0x2B
#define FILTER_CTL      0x2C
#define POWER_CTL       0x2D
#define SELF_TEST       0x2E

/* ADXL const parameters */
#define SOFT_RESET_ADXL362      (0x52)

#define POWER_CTL_PARAM_LOWNOISE_NORM   (0x00)
#define POWER_CTL_PARAM_LOWNOISE_LOW    (0x10)
#define POWER_CTL_PARAM_LOWNOISE_ULTRA  (0x20)

#define POWER_CTL_MODEMASK      (0x03)
#define POWER_CTL_STOP          (0x00)
#define POWER_CTL_STANDBY       (0x01)
#define POWER_CTL_MESURE        (0x02)

/* ADXL362 configuration */     
#define DEVID_AD_ADXL362        (0xAD)
#define DEVID_MST_ADXL362       (0x1D)
#define PARTID_ADXL362          (0xF2)

#define GRAVITY_2G              (2)
#define GRAVITY_4G              (4)
#define GRAVITY_8G              (8)

#define ODR_12                  0
#define ODR_25                  1
#define ODR_50                  2
#define ODR_100                 3
#define ODR_200                 4
#define ODR_400                 5


#define PARAM_ADXL362_SCALE_ACCEL     (1.0f * 0.001f * 9.80665f)  // DATA
#define PARAM_ADXL362_SCALE_THERMAL   (0.0025f)                   // TEMP
#define PARAM_ADXL362_THERMAL_OFFSET  (25.0f)                     // TEMP



/* Output of Accelerometers */
typedef struct _struct_AccelTemp {
    int ax;
    int ay;
    int az;
    int tm;
} AccelTemp;

/* ADIS16460 class definition */
class ADXL362 {

public:

    /* ADIS16460 initializer */
    ADXL362(Serial*, SPI*);
    ~ADXL362();
    
    /* Control */
    void SoftReset();
    void SetMesureParam(int param);
    void StartMesure();
    int GetStatus();

    /* Sensing */
    void SensorRead(AccelTemp*);

    /* GetSubInfo */
    AccelTemp* GetMinInfo(void);
    AccelTemp* GetMaxInfo(void);
    
    /* convert real scale */
    float ConvAccel(int ctrlval);
    float ConvThermal(int ctrlval);
    
    /* configuration */
    void set_gravity(int g);
    void set_ODR(int o);
    void set_powermode(int m);
    void set_wakeupmode(void);
    void set_scalefactor(void);
    void start(void);
    void stop(void);
        
private:    
    /* locked */
    ADXL362();

    /* information store */
    Serial *uart;
    SPI *_spi;
    DigitalOut *_cs;
    int odr;
    AccelTemp minStore;
    AccelTemp maxStore;
    
    /* realvalue */
    float gravity;
    float scaleAccel;
    float scaleThermal;
    float offsetThermal;

    /* convert value */
    void convertSensorData(AccelTemp*, int *);
    int ext12bitToInt(int l, int h);
    
    /* update internal min/max */
    void initMinMax(AccelTemp *min, AccelTemp *max);
    void updateMinMax(AccelTemp *min, AccelTemp *max, AccelTemp *getData);
     
    
    /* communication via SPI*/
    void chipSelOn(void);
    void chipSelOff(void);
    void chipSelDelay(void);
    
    /* R/W primitives */
    int regRD(int);
    void regWR(int, int);
    void regBurstRD(int, int, int*);
};

#endif /* _ADXL362_H_ */