/* mbed Microcontroller Library
 * Copyright (c) 2018 ARM Limited
 * SPDX-License-Identifier: Apache-2.0
 */

#include "mbed.h"
#include "stats_report.h"

#define ADT7420 0x48

#define RESET_REG 0x2F
#define TEMP_REG 0x00
#define ID_REG 0x0B


DigitalOut led1(LED1);
DigitalOut sensor(D8);

I2C Myi2c(I2C_SDA, I2C_SCL);

Serial pc(USBTX, USBRX);

void ADT7420_reset(void);
char ADT7420_GetID(void);
int ADT7420_GetTemp(void);

int main() {
    float status;
    int res;
    sensor=1;
    //configure for UART
    pc.baud(115200);
    pc.printf("I2C ADT7420 Demo\n");
   
    //configure for I2C @100KHz
    //Myi2c.init();
    Myi2c.frequency(10000);
   
    //configure for ADT7420
    Myi2c.lock();
    pc.printf("[RESET ] ADT7420\n"); 
    ADT7420_reset();
    wait(0.5);

    pc.printf("[CHECK ID] ADT7420\n"); 
    ADT7420_GetID();

    
    while (true) {
        led1 = 0;
        
        pc.printf("[Get Temp] ADT7420\n"); 
        res = ADT7420_GetTemp();
        
        if(res & 0x1000)
        {
            status = (float)(res * 0.0625 * -1.0);
            
        }
        else
        {
            status = (float)(res * 0.0625);
        }
        
        pc.printf("Current Temp %.4f C\n", status);
            
        wait(0.5);
        led1 = 1;
        wait(0.5);
    }
    
}

void ADT7420_reset(void)
{
    char cmd_reset;
    cmd_reset = RESET_REG;
    Myi2c.write(ADT7420);
    if(Myi2c.write(0xFF))
    {
        pc.printf("Ack \n");
    }
    else
    {
        pc.printf("Nack \n");
    }
    
    Myi2c.write(ADT7420);
    if(Myi2c.write(cmd_reset))
    {
        pc.printf("Reset Done\n");
    }
    else
    {
        pc.printf("Reset Failure\n");
    }
}
    
char ADT7420_GetID(void)
{
    char cmd_id, read_val;
    int sts;
    cmd_id=ID_REG;
    //Myi2c.write(ADT7420, &cmd_id, 1, 0);
    sts = Myi2c.read(ADT7420, &cmd_id, 1, 0);
    if(sts==0)
    {
        pc.printf("ID ACK\n");
    }
    else
    {
        pc.printf("ID NACK\n");
        pc.printf("Return Value STS %d \n", sts);
    }
    Myi2c.stop();
    pc.printf("ID REG %02x\n", cmd_id);
    return cmd_id;
}

int ADT7420_GetTemp(void)
{
    char cmd_temp[1], read_val[2];
    int temp=0;
    cmd_temp[0]=TEMP_REG;
    Myi2c.start();
    Myi2c.write(ADT7420, cmd_temp, 2);
    wait(0.2);
    Myi2c.read(ADT7420, read_val, 3);
    pc.printf("Temp Upper %02x\n", read_val[0]);
    pc.printf("Temp Lower %02x\n", read_val[1]);
    
    temp = (int)((read_val[0] << 8) | read_val[1]);
    temp >>= 3;
    return temp;
}
