/*
Copyright (c) 2016, Dust Networks. All rights reserved.

Port of the uart module to the NUCLEO-L053R8.

\license See attached DN_LICENSE.txt.
*/

#include "dn_uart.h"
#include "dn_ipmt.h"
#include "dn_debug.h"
#include "mbed.h"


//=========================== defines =========================================

// Set correct pins for external UART on your board (USART1 for NUCLEO-F411)
#define UART_MOTE_TX	PA_9
#define UART_MOTE_RX	PA_10


//=========================== variables =======================================

typedef struct {
	dn_uart_rxByte_cbt	ipmt_uart_rxByte_cb;
} dn_uart_vars_t;

static dn_uart_vars_t dn_uart_vars;
static Serial serialMote(UART_MOTE_TX, UART_MOTE_RX);


//=========================== prototypes ======================================

void moteRXinterrupt(void);

//=========================== public ==========================================

void dn_uart_init(dn_uart_rxByte_cbt rxByte_cb)
{
	// Store RX callback function
	dn_uart_vars.ipmt_uart_rxByte_cb = rxByte_cb;
	
	/* Default configuration for Serial:
		- 8 bit character size
		- No Parity
		- 1 bit stop bit
		- No flow control
		- 9600 baudrate
	Hence, we only need to change the baudrate */
	serialMote.baud(115200);
	
	// Attach RX interrupt handler
    serialMote.attach(&moteRXinterrupt, Serial::RxIrq);

	//debug("SMIP Serial Initialized");
}

void dn_uart_txByte(uint8_t byte)
{
	serialMote.putc(byte);
}

void dn_uart_txFlush()
{
	// Nothing to do since we push byte-by-byte
}

//=========================== private =========================================

//=========================== helpers =========================================

//=========================== interrupt handlers ==============================

void moteRXinterrupt(void)
{
    while (serialMote.readable())
    {
        dn_uart_vars.ipmt_uart_rxByte_cb(serialMote.getc());
    }
}

