#include "mbed.h"
#include "SDFileSystem.h"
#include "MB85RSxx_SPI.h"
#include "pinmap.h"

// FRAM Address 
#define POWR_FLAG_ADDR 0x0000
#define SYNC_FLAG_ADDR 0x0008
#define FILE_SYNC_ADDR 0x0010
#define DATA_ADDR 0x0100

// System Status Flag
#define POWER_OK   0xAA
#define POWER_FAIL 0xBB
#define SYNC_OK    0xCC
#define SYNC_FAIL  0xDD

// FileSystem Status
#define FILE_OPEN       0x11
#define FILE_PRE_WRITE  0x22
#define FILE_POST_WRITE 0x33
#define FILE_CLOSE      0x44
#define FILE_SYNC       0x55
#define FILE_READ       0x66  // Unused 


//SPI ch1 for SD FileSystem
SDFileSystem sd(D11, D12, D13, D10, "sd", D8, SDFileSystem::SWITCH_NONE, 25000000);
//SPI ch3 for FRAM 
// CLK 10MHz MODE 8.0
MB85RSxx_SPI fram(PC_12, PC_11, PC_10, PD_2);

// Application
char buffer[32];  // Write Buffer
char valbuf[20];  // Samplig Data Buffer
AnalogIn analog_value(A0); // Analog Input Port if use
time_t seconds = time(NULL); // Time stamp if use

int addr=POWR_FLAG_ADDR; // for FRAM POWR_FLAG_ADDR

//Serial pc(USBTX, USBRX) 
// Printf is output for COM port with 9600bps.
// You can use SerialPC for debug console instead of above it.

// FRAM Pointer Get
int fram_get_addr(void)
{
    return addr;
}

// FRAM Pointer Set
void fram_set_addr(int adr)
{
    addr=adr;
}

// Status Flag Set
void sys_set_status(int adr, char flg)
{
    fram_set_addr(adr);
    fram.write(fram_get_addr(), flg);
}

// Status Flag Get
char sys_get_status(int adr)
{
    fram_set_addr(adr);
    return fram.read(fram_get_addr());
}

// RAW Data save for FRAM, and write SD 
void sys_write(FileHandle* file, char *buf, int size)
{
    int tmp = fram_get_addr();   // Get Current FRAM Address Pointer
    //tmp+=fram_addr;              // Set Current FRAM Address Pointer 
    
    fram_set_addr(tmp);          // Fram Write Address Pointer Set
    sys_set_status(FILE_SYNC_ADDR, FILE_PRE_WRITE);  // Flag Set for Pre write
    fram.write(fram_get_addr(), buf, size);     // Save Data
    file->write(buf, size);                     // Write File
    sys_set_status(FILE_SYNC_ADDR, FILE_POST_WRITE); // Flag Set for Post write
    fram_set_addr(tmp+size);     // Save Current FRAM Address Pointer
}
    
// Application 
void write_datas(char *filename)
{
    float adc_avr_val=0.0;
    int cnt1, cnt2;
    set_time(1498465898+32400);
    memset(buffer, 0, sizeof(buffer));
    
    sys_set_status(SYNC_FLAG_ADDR, SYNC_FAIL); // Set SYNC Flag as Fail
    sys_set_status(SYNC_FLAG_ADDR+4, SYNC_OK); // Set Acctual SYNC Flag as OK
    sys_set_status(FILE_SYNC_ADDR, FILE_OPEN);
    FileHandle* file = sd.open(filename, O_WRONLY | O_CREAT | O_TRUNC);
    
    sprintf(buffer, "{\r\n\"adc log data\":[");
    
    fram_set_addr(DATA_ADDR);  
    sys_write(file, &buffer[0], 19);
    
    sprintf(&buffer[0], "\"time\":%d ,", seconds);
    
    sys_write(file, &buffer[0], 19);    
    
    for(cnt1=0;cnt1 < 100;cnt1++) {
        memset(buffer, 0, sizeof(buffer));
        sprintf(&buffer[0], "\r\n{\"Samples\":%d ,", cnt1);
        sys_write(file, &buffer[0], 18);        
        for(cnt2=0;cnt2 < 10; cnt2++) {
            //adc_avr_val+=analog_value.read();
            adc_avr_val+=analog_value.read();
            ctime(&seconds);
        }
        //adc_avr_val=adc_avr_val/10;
        //sprintf(&buffer[0], "\"time\":%d ,", seconds);
        //file->write(&buffer[0], 19);
        sprintf(&valbuf[0], "\"averages\":%.f}", adc_avr_val*3300);
        sys_write(file, &valbuf[0], sizeof(valbuf));
        if(cnt1 < 99)
        {
            sprintf(&buffer[0], ",");
            sys_write(file, &buffer[0], 1);
            memset(valbuf, 0, sizeof(valbuf));
            
        }
        else
        {
            sprintf(&buffer[0], "\n");
            sys_write(file, &buffer[0], 1);
        }
    }
    sprintf(&buffer[0], "]}\n");
    sys_write(file, &buffer[0],2);
    
    sys_set_status(FILE_SYNC_ADDR, FILE_CLOSE);
    file->close();
    sys_set_status(FILE_SYNC_ADDR, FILE_SYNC);
    sys_set_status(SYNC_FLAG_ADDR, SYNC_OK); // Sync Flag Set as Good

}

void System_Resume(void)
{

}

int main()
{
    int num=0, f=1;
    char fname[14];
     //Configure CRC, large frames, and write validation
    sd.crc(true);
    sd.large_frames(true);
    sd.write_validation(true);
    
    // FRAM Initialize
    fram.Init();
    
    //for(int i=0; i < 512; i++)
    //{
    //    fram.write(i, 0x00, 1);
    //}
    
    sys_set_status(POWR_FLAG_ADDR+4, POWER_OK);  // Current Power Status
    //fram_set_powerflag(0);
    
    // Check FRAM Power Status
    if(sys_get_status(POWR_FLAG_ADDR) == POWER_FAIL) {
        printf("Power Down Occured!\n");
        
        // Power Down Recovery
        System_Resume();
        
    } else {
        printf("No Trouble Found for Power.\n");
        // FRAM Address Set
        //fram_set_addr(0);
    }
    
    sys_set_status(POWR_FLAG_ADDR, POWER_FAIL); //Set Flag as Power Fail
    printf("Log Start!\n");
    while(f) {
        sprintf(fname, "d_log%03d.json", num);
        //Try to mount the SD card
        //printf("\nMounting SD card...");
        if (sd.mount() != 0) {
            printf("SD Mount failed!\n");
            continue;
        }

        printf("log %d : start!\n", num);        
        //Start Logging
        write_datas(fname);
        //printf("log %d : success!\n", num);        
        
        if(num > 32) f=0;
        else num++;
    }
    sys_set_status(POWR_FLAG_ADDR, POWER_OK); //Set Flag as Power OK
    printf("Log Done!\n");
}
