/**
 ******************************************************************************
 * @file    MB85RSxx_SPI.cpp
 * @author  APS Lab
 * @version V1.0.0
 * @date    26 June 2017
 * @brief   MB85RSxx_SPI class implementation
 ******************************************************************************
 * @attention
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
#include "mbed.h"
#include "MB85RSxx_SPI.h"

MB85RSxx_SPI::MB85RSxx_SPI(PinName mosi, PinName miso, PinName sclk, PinName nss)
    :
    _spi_p(new SPI(mosi, miso, sclk)), 
    _spi(*_spi_p),
    _di_p(new DigitalOut(nss)),
    _di(*_di_p)
{
    _spi.format(8,0);
    _spi.frequency(10000000);
}

MB85RSxx_SPI::~MB85RSxx_SPI()
{
    if (NULL != _spi_p)
        delete  _spi_p;
}

void MB85RSxx_SPI::Init(void)
{
    char sts;
    _di=0;
    _spi.write(WRDI);
    _di=1;
    wait(0.2);
    _di=0;
    _spi.write(WREN);
    _di=1;
    wait(0.2);
    _di=0;
    _spi.write(WRSR);
    _spi.write(SR_WEL);
    _di=1;
    wait(0.2);
    _di=0;
    _spi.write(RDSR);
    sts=_spi.write(0x00);
    _di=1;
    printf("FRAM Status %x\n", sts);
}

void MB85RSxx_SPI::write(uint32_t address, char data)
{
    _di=0;
    _spi.write(WREN);
    _di=1;
    _di=0;
    _spi.write(WRITE);
    _spi.write((address & 0x3F00) >> 8);//Addr H for 64Kbits
    _spi.write((address & 0x00FF)); //Addr L for 64Kbits
    _spi.write(data);  //Write Data
    _di=1;
}

char MB85RSxx_SPI::read(uint32_t address)
{
    char ch;
    _di=0;
    _spi.write(READ);
    _spi.write((address & 0x3F00) >> 8);//Addr H for 64Kbits
    _spi.write((address & 0x00FF)); //Addr L for 64Kbits
    ch = _spi.write(0x00);//Write dummy 0x00, Reade Data
    _di=1;
    return ch;
} 


void MB85RSxx_SPI::write(uint32_t address, char *data, uint32_t length)
{
    int idx;
    for(idx=0; idx < length; idx++)
    {
        MB85RSxx_SPI::write(address+idx, *(data+idx));
    }
}

void MB85RSxx_SPI::read(uint32_t address, char *data, uint32_t length)
{
    uint32_t idx;
    for(idx=0; idx < length; idx++)
    {
        *(data+idx) = MB85RSxx_SPI::read(address+idx);
    }
} 

