#include "mbed.h"
#include "mDot.h"
#include "MTSLog.h"
#include "SPISlave.h"
#include <string>
#include <vector>
#include <algorithm>

// these options must match the settings on your Conduit
// uncomment the following lines and edit their values to match your configuration
static std::string config_network_name = "gobucks1";
static std::string config_network_pass = "gobucks1";
static uint8_t config_frequency_sub_band = 1;

int main()
{
    int32_t ret;
    int i = 0;
    mDot* dot;
    std::vector<uint8_t> data;
    //uint8_t Q = 1;
    //Instantiate uint8_t for spi read data
    uint8_t spi_data = 0;
    uint8_t spi_true = 0;

    //Instantiate mDot as SPI Slave 
    //FOR mDot: MOSI is PA_7, MISO is PA_6, SCLK is PA_5, NSS is PA_4
    SPISlave mdot_slave(PA_7, PA_6, PA_5, PA_4); // mosi, miso, sclk, ssel
    //Set up spi format with 8 bit data format, mode 0 for mDot slave
    mdot_slave.format(8,0);
    //Set up 1 MHz frequency for spi transfer
    mdot_slave.frequency(1000000);

    // get a mDot handle
    dot = mDot::getInstance();

    // print library version information
    logInfo("version: %s", dot->getId().c_str());

    //*******************************************
    // configuration
    //*******************************************
    // reset to default config so we know what state we're in
    dot->resetConfig();

    dot->setLogLevel(mts::MTSLog::INFO_LEVEL);

    // set up the mDot with our network information: frequency sub band, network name, and network password
    // these can all be saved in NVM so they don't need to be set every time - see mDot::saveConfig()

    // frequency sub band is only applicable in the 915 (US) frequency band
    // if using a MultiTech Conduit gateway, use the same sub band as your Conduit (1-8) - the mDot will use the 8 channels in that sub band
    // if using a gateway that supports all 64 channels, use sub band 0 - the mDot will use all 64 channels

//    logInfo("setting to public network");
//    if ((ret = dot->setPublicNetwork(true)) != mDot::MDOT_OK) {
//        logError("failed to set public network %d:%s", ret, mDot::getReturnCodeString(ret).c_str());
//    }

    logInfo("setting frequency sub band");
    if ((ret = dot->setFrequencySubBand(config_frequency_sub_band)) != mDot::MDOT_OK) {
        logError("failed to set frequency sub band %d:%s", ret, mDot::getReturnCodeString(ret).c_str());
    }

    logInfo("setting network name");
    if ((ret = dot->setNetworkName(config_network_name)) != mDot::MDOT_OK) {
        logError("failed to set network name %d:%s", ret, mDot::getReturnCodeString(ret).c_str());
    }

    logInfo("setting network password");
    if ((ret = dot->setNetworkPassphrase(config_network_pass)) != mDot::MDOT_OK) {
        logError("failed to set network password %d:%s", ret, mDot::getReturnCodeString(ret).c_str());
    }

    // a higher spreading factor allows for longer range but lower throughput
    // in the 915 (US) frequency band, spreading factors 7 - 10 are available
    // in the 868 (EU) frequency band, spreading factors 7 - 12 are available
    logInfo("setting TX spreading factor");
    if ((ret = dot->setTxDataRate(mDot::SF_10)) != mDot::MDOT_OK) {
        logError("failed to set TX datarate %d:%s", ret, mDot::getReturnCodeString(ret).c_str());
    }

    // request receive confirmation of packets from the gateway
    logInfo("enabling ACKs");
    if ((ret = dot->setAck(1)) != mDot::MDOT_OK) {
        logError("failed to enable ACKs %d:%s", ret, mDot::getReturnCodeString(ret).c_str());
    }

    // save this configuration to the mDot's NVM
    logInfo("saving config");
    if (! dot->saveConfig()) {
        logError("failed to save configuration");
    }
    //*******************************************
    // end of configuration
    //*******************************************

    // attempt to join the network
    logInfo("joining network");
    while ((ret = dot->joinNetwork()) != mDot::MDOT_OK) {
        logError("failed to join network %d:%s", ret, mDot::getReturnCodeString(ret).c_str());
        // in the 868 (EU) frequency band, we need to wait until another channel is available before transmitting again
        osDelay(std::max((uint32_t)1000, (uint32_t)dot->getNextTxMs()));
    }

    //data.push_back(Q);
    
    // Prime SPI with first reply
    //mdot_slave.reply(0);

    while (true) {

        while(i<10000){
            if(mdot_slave.receive()){
                spi_data=11;
                spi_true=1;
            }
            else{
                spi_data=10;
            }
            i++;
        }
        /* 
        if(mdot_slave.receive()) {
            //Read byte from master
            spi_data = mdot_slave.read();
            //Reply spi after slave reading
            mdot_slave.reply(0);
            
            //push received spi data to data packet vector
            data.push_back(spi_data);
            
            // send the data to the gateway
            if ((ret = dot->send(data)) != mDot::MDOT_OK) {
                logError("failed to send", ret, mDot::getReturnCodeString(ret).c_str());
            } else
                logInfo("successfully sent data to gateway");

            // in the 868 (EU) frequency band, we need to wait until another channel is available before transmitting again
            osDelay(std::max((uint32_t)5000, (uint32_t)dot->getNextTxMs()));
        
            //Q++;
            //data.clear();
            //data.push_back(Q);
            //printf("\nQ = %u\n",Q);
            //printf("Q vector = %u\n",data[0]);
    
            //end slave receive if statement
        }
        else{
            spi_data = 10;
        */
            //push received spi data to data packet vector
            data.push_back(spi_data);
            data.push_back(spi_true);
            // send the data to the gateway
            if ((ret = dot->send(data)) != mDot::MDOT_OK) {
                logError("failed to send", ret, mDot::getReturnCodeString(ret).c_str());
            } else
                logInfo("successfully sent data to gateway");

            // in the 868 (EU) frequency band, we need to wait until another channel is available before transmitting again
            osDelay(std::max((uint32_t)5000, (uint32_t)dot->getNextTxMs()));
        //}
        data.clear();
        spi_true = 0;
        i = 0;
    //end while(true) loop
    }
    return 0;
}

