#include "mbed.h"
#include "kbt.h"
#define ROOT 0.2886;

KBT kbt ( PC_10, PC_11);  //TX4,RX4
Serial pc( USBTX, USBRX);

PwmOut F (PC_8);  //前pwm値
DigitalOut FA (PC_5);
DigitalOut FB (PB_12);

PwmOut R (PC_6);  //右pwm値
DigitalOut RA (PB_6);
DigitalOut RB (PC_7);

PwmOut L (PB_14);  //左pwm値
DigitalOut LA (PB_15);
DigitalOut LB (PB_1);

void forward(){
    F = 0.5;
    R = 0.5;
    L = 0.5;

    FA = 1; 
    FB = 1;
    RA = 1;
    RB = 0;
    LA = 0;
    LB = 1;
}

void back(){
    F = 0.5;
    R = 0.5;
    L = 0.5;

    FA = 1; 
    FB = 1;
    RA = 0;
    RB = 1;
    LA = 1;
    LB = 0;
}

void leftmove(){
    F = 0.5;
    R = ROOT;
    L = ROOT;

    FA = 1;
    FB = 0;
    RA = 0;
    RB = 1;
    LA = 0;
    LB = 1;
}

void rightmove(){
    F = 0.5;
    R = ROOT;
    L = ROOT;

    FA = 0; 
    FB = 1;
    RA = 1;
    RB = 0;
    LA = 1;
    LB = 0;
}

void leftrotate(){
    F = 0.5;
    R = 0.5;
    L = 0.5;

    FA = 1; 
    FB = 0;
    RA = 1;
    RB = 0;
    LA = 1;
    LB = 0;
}

void rightrotate(){
    F = 0.5;
    R = 0.5;
    L = 0.5;

    FA = 0; 
    FB = 1;
    RA = 0;
    RB = 1;
    LA = 0;
    LB = 1;
}

void stop(){
    F = 0.5;
    R = 0.5;
    L = 0.5;
    
    FA = 1; 
    FB = 1;
    RA = 1;
    RB = 1;
    LA = 1;
    LB = 1;
}

int main(){
    kbt.init(2400);
    
    while(true){
        if (kbt.button(up) == 1)          forward();
        else if (kbt.button(down) == 1)   back();
        else if (kbt.button(right) == 1)  rightmove();
        else if (kbt.button(left) == 1)   leftmove();
        else if (kbt.button(L1) == 1)     rightrotate();
        else if (kbt.button(R1) == 1)     leftrotate();
        else                              stop();
        }
    }
