#include "stm32f103c8t6.h"
#include "mbed.h"

#define pow1 0.5
#define pow2 0.7
#define time 0.7

DigitalOut led( LED1);
CANMessage msg;
CAN Reseive ( PA_11, PA_12);

PwmOut dcY( PA_8);//Y軸のpwmピン
DigitalOut motordcY1( PB_15);
DigitalOut motordcY2( PB_14);

PwmOut dcZ( PB_3);//Z軸のpwmピン
DigitalOut motordcZ1( PA_15);
DigitalOut motordcZ2( PA_12);

DigitalIn switch1( PA_1);
DigitalIn switch2( PA_2);
DigitalIn switch3( PA_3);
DigitalIn switch4( PA_4);//micro switch x 4

int mode = 0;

void motorForward()
{
    dcY.period_us( 50);
    dcY = pow1;
    motordcY1 = 1;
    motordcY2 = 0;
}
void motorBack()
{
    dcY.period_us( 50);
    dcY = pow1;
    motordcY1 = 0;
    motordcY2 = 1;
}
void motorDown()
{
    dcZ.period_us( 50);
    dcZ = pow2;
    motordcZ1 = 0;
    motordcZ2 = 1;
}
void motorUp()
{
    dcZ.period_us( 50);
    dcZ = pow2;
    motordcZ1 = 1;
    motordcZ2 = 0;
}
void motorStopY()//Y軸が止まる
{
    motordcY1 = 0;
    motordcY2 = 0;
}
void case0(){
    if( switch1.read() == 0){
        motorBack();
        if( switch1.read() == 1)
            motorStopY();
        }
    else if( switch1.read() == 1)
        motorStopY();
    mode = 1;
}
void case1(){
    motorForward();
    motorUp();
    //wait( time);
    mode = 2;
}
void case2(){
    motorForward();
    motorDown();
    //wait( time);
    mode = 3;
}
void case3(){
    motorBack();
    motorDown();
    //wait( time);
    mode = 4;
}
void case4(){
    motorBack();
    motorUp();
    //wait( time);
    mode = 1;
}

int main(){
    /*led.write(0);
    
    while( true){
        if( Reseive.id == 1 ){
            data
            }
        wait( 0.1);
        }*/

    while(1){      
        switch( mode){
            case 0:
            case0();
            break;
            case 1:
            case1();
            break;
            case 2:
            case2();
            break;
            case 3:
            case3();
            break;
            case 4:
            case4();
            break;
        }
        
        if( switch1.read() == 0)
            led.write(0);
        else if( switch1.read() == 1)
            led.write(1);
            
        wait( time);
        }
}
