/*
SSD1353TileGraphics - main.cpp

Copyright 2018 ADay (or "ikubaku")

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/

#include "mbed.h"
#include "stdio.h"

#include "main.h"

#define CD_PIN P4_29
#define NRES_PIN P4_28
#define MOSI_PIN P0_18
#define MISO_PIN P0_17
#define SCK_PIN P0_15
#define CS_PIN P0_4

#define LED_PIN P1_18

// 1 bit tile framebuffer
#define TL_WIDTH 6
#define TL_HEIGHT 8
#define TL_HORZ 26
#define TL_VERT 16

#define FPS 30

byte fillR = 0xFF;
byte fillG = 0xFF;
byte fillB = 0xFF;

//const uint32_t tiles[] = {0x00000000, 0x747F1880, 0xE4BD1F00, 0x7C210780, 0xF4631F00, 0xFC3F0F80, 0xFC3F0800, 0x7C2F1780, 0x8C7F1880, 0x71084700, 0x71094400, 0x8DB14980, 0x84210F80, 0xDD6B1880, 0x8E6B3880, 0x74631700, 0xF47D0800, 0x64A56780, 0xF47D8B80, 0x7C1C1F00, 0xF9084200, 0x8C631700, 0x8C54A200, 0x8C6B5D80, 0xDA88AD80, 0x8A884200, 0xF8888F80, 0x21080200, 0x744C0200, 0x57D5F500, 0x00004400, 0x00000400, 0x01004000, 0x746B1700, 0x23084700, 0x744C8F80, 0x744D1700, 0x32A5F100, 0xF43C1700, 0x741D1700, 0xFC444200, 0x745D1700, 0x745C1700};
//const uint32_t test_tiles[] = {0x00000000, 0x00000000};
//const uint64_t test_tiles[] = {0x0000000000000000, 
//                                0xFFFFFFFFFFFFFFFF, 
//                                0x3C7EE7C3FFFFC3C3};
const byte tiles[] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x3A, 0x51, 0x41, 0x45, 0x2E, 0x00, 0x3E, 0x44, 0x41, 0x11, 0x3E, 0x00, 0x1E, 0x41, 0x63, 0x41, 0x3C, 0xFF, 0xC1, 0xB1, 0x8D, 0x83, 0xFF, 0x00, 0xDB, 0xDB, 0xDB, 0xDB, 0x00, 0x00, 0x1B, 0x1B, 0x1B, 0x1B, 0x00, 0x00, 0x03, 0x03, 0x03, 0x03, 0x00, 0x00, 0x03, 0x01, 0x01, 0x01, 0x00, 0x7F, 0x61, 0xD1, 0xC5, 0x43, 0x7F, 0x88, 0x50, 0x22, 0x52, 0x88, 0x00, 0x00, 0x00, 0x02, 0x02, 0x00, 0x00, 0x00, 0x08, 0x12, 0x12, 0x08, 0x00, 0x20, 0x48, 0x92, 0x92, 0x48, 0x20, 0x00, 0x08, 0x11, 0x7F, 0x11, 0x08, 0x00, 0x07, 0x1E, 0x7C, 0x1E, 0x07, 0xF8, 0xA8, 0x68, 0x18, 0x0F, 0x08, 0x30, 0xE8, 0x2E, 0xE9, 0x31, 0x06, 0x7E, 0x81, 0xB9, 0x89, 0x81, 0x7E, 0x2C, 0x2A, 0x28, 0x28, 0xA8, 0x68, 0x2C, 0x2A, 0x28, 0x28, 0xAB, 0x6B, 0x00, 0xC0, 0xA0, 0xFF, 0xA0, 0xC0, 0x00, 0x11, 0x0A, 0x04, 0x0A, 0x11, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x0F, 0x00, 0x00, 0x00, 0x03, 0x00, 0x0F, 0x00, 0x3F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7D, 0x00, 0x00, 0x00, 0x00, 0x60, 0x00, 0x60, 0x00, 0x00, 0x24, 0x7F, 0x24, 0x7F, 0x12, 0x00, 0x12, 0x2A, 0x7F, 0x2A, 0x24, 0x00, 0x33, 0x4C, 0x3E, 0x19, 0x66, 0x00, 0x36, 0x49, 0x35, 0x06, 0x05, 0x00, 0x00, 0x00, 0x00, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3E, 0x41, 0x00, 0x41, 0x3E, 0x00, 0x00, 0x00, 0x00, 0x22, 0x14, 0x7F, 0x14, 0x22, 0x00, 0x08, 0x08, 0x3E, 0x08, 0x08, 0x00, 0x01, 0x06, 0x06, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x01, 0x06, 0x08, 0x30, 0x40, 0x00, 0x3E, 0x51, 0x49, 0x45, 0x3E, 0x00, 0x00, 0x21, 0x7F, 0x01, 0x00, 0x00, 0x21, 0x43, 0x45, 0x49, 0x31, 0x00, 0x22, 0x49, 0x49, 0x49, 0x36, 0x00, 0x0C, 0x14, 0x24, 0x7F, 0x04, 0x00, 0x72, 0x51, 0x51, 0x51, 0x4E, 0x00, 0x3E, 0x49, 0x49, 0x49, 0x26, 0x00, 0x60, 0x40, 0x43, 0x4C, 0x70, 0x00, 0x36, 0x49, 0x49, 0x49, 0x36, 0x00, 0x32, 0x49, 0x49, 0x49, 0x3E, 0x00, 0x00, 0x00, 0x36, 0x00, 0x00, 0x00, 0x00, 0x02, 0x34, 0x00, 0x00, 0x00, 0x00, 0x08, 0x14, 0x22, 0x00, 0x00, 0x14, 0x14, 0x14, 0x14, 0x14, 0x00, 0x00, 0x00, 0x22, 0x14, 0x08, 0x00, 0x20, 0x40, 0x4D, 0x48, 0x30, 0x00, 0x3E, 0x4D, 0x55, 0x55, 0x3C, 0x00, 0x3F, 0x48, 0x48, 0x48, 0x3F, 0x00, 0x7F, 0x49, 0x49, 0x39, 0x06, 0x00, 0x3E, 0x41, 0x41, 0x41, 0x22, 0x00, 0x7F, 0x41, 0x41, 0x41, 0x3E, 0x00, 0x7F, 0x49, 0x49, 0x49, 0x49, 0x00, 0x7F, 0x48, 0x48, 0x48, 0x48, 0x00, 0x3E, 0x41, 0x49, 0x49, 0x2F, 0x00, 0x7F, 0x08, 0x08, 0x08, 0x7F, 0x00, 0x00, 0x41, 0x7F, 0x41, 0x00, 0x00, 0x02, 0x41, 0x7E, 0x40, 0x00, 0x00, 0x7F, 0x08, 0x14, 0x22, 0x41, 0x00, 0x7F, 0x01, 0x01, 0x01, 0x01, 0x00, 0x7F, 0x18, 0x07, 0x18, 0x7F, 0x00, 0x7F, 0x20, 0x18, 0x04, 0x7F, 0x00, 0x3E, 0x41, 0x41, 0x41, 0x3E, 0x00, 0x7F, 0x48, 0x48, 0x48, 0x30, 0x00, 0x3E, 0x41, 0x4D, 0x42, 0x3D, 0x00, 0x7F, 0x48, 0x4C, 0x4A, 0x31, 0x00, 0x32, 0x49, 0x49, 0x49, 0x26, 0x00, 0x40, 0x40, 0x7F, 0x40, 0x40, 0x00, 0x7E, 0x01, 0x01, 0x01, 0x7E, 0x00, 0x70, 0x0E, 0x01, 0x0E, 0x70, 0x00, 0x7F, 0x06, 0x18, 0x06, 0x7F, 0x00, 0x63, 0x14, 0x08, 0x14, 0x63, 0x00, 0x60, 0x18, 0x07, 0x18, 0x60, 0x00, 0x41, 0x57, 0x49, 0x75, 0x41, 0x00, 0x00, 0x00, 0x7F, 0x41, 0x41, 0x00, 0x40, 0x30, 0x08, 0x06, 0x01, 0x00, 0x41, 0x41, 0x7F, 0x00, 0x00, 0x00, 0x00, 0x20, 0x40, 0x20, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x40, 0x20, 0x00, 0x00, 0x00, 0x13, 0x15, 0x15, 0x0F, 0x00, 0x00, 0x7F, 0x09, 0x09, 0x06, 0x00, 0x00, 0x06, 0x09, 0x09, 0x00, 0x00, 0x06, 0x09, 0x09, 0x7F, 0x00, 0x00, 0x00, 0x0E, 0x15, 0x15, 0x08, 0x00, 0x00, 0x08, 0x3F, 0x28, 0x00, 0x00, 0x08, 0x15, 0x15, 0x0A, 0x10, 0x00, 0x00, 0x7F, 0x08, 0x07, 0x00, 0x00, 0x00, 0x00, 0x2F, 0x00, 0x00, 0x00, 0x02, 0x01, 0x2E, 0x00, 0x00, 0x00, 0x00, 0x7F, 0x04, 0x0A, 0x11, 0x00, 0x00, 0x7E, 0x01, 0x00, 0x00, 0x00, 0x0F, 0x08, 0x07, 0x08, 0x07, 0x00, 0x00, 0x0F, 0x04, 0x08, 0x08, 0x07, 0x00, 0x06, 0x09, 0x09, 0x06, 0x00, 0x00, 0x3F, 0x28, 0x28, 0x10, 0x00, 0x10, 0x28, 0x28, 0x3F, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x04, 0x08, 0x00, 0x08, 0x15, 0x15, 0x02, 0x00, 0x00, 0x00, 0x08, 0x1F, 0x09, 0x00, 0x00, 0x00, 0x0E, 0x01, 0x01, 0x0F, 0x00, 0x00, 0x0E, 0x01, 0x02, 0x0C, 0x00, 0x0E, 0x01, 0x06, 0x01, 0x0E, 0x00, 0x00, 0x09, 0x06, 0x09, 0x00, 0x00, 0x00, 0x0C, 0x03, 0x0C, 0x00, 0x00, 0x00, 0x09, 0x0B, 0x0D, 0x09, 0x00, 0x00, 0x00, 0x08, 0x7F, 0x41, 0x00, 0x00, 0x00, 0x7F, 0x00, 0x00, 0x00, 0x41, 0x7F, 0x08, 0x00, 0x00, 0x00, 0x00, 0x20, 0x40, 0x20, 0x40, 0x00, 0x7F, 0x41, 0x41, 0x41, 0x7F, 0x00};

byte tilebuf[TL_HORZ*TL_VERT];
byte color = 0xFF;


// I/O
DigitalOut cs_pin(CS_PIN);
DigitalOut cd_pin(CD_PIN);
DigitalOut nres_pin(NRES_PIN);

DigitalOut led_pin(LED_PIN);

SPI spi(MOSI_PIN, MISO_PIN, SCK_PIN);

void sendCommand(byte com) {
    cd_pin = 0;
    spi.write(com);
}
void sendData(byte dat) {
    cd_pin = 1;
    spi.write(dat);
}

void beginSend() {
    cs_pin = 0;
}
void endSend() {
    cs_pin = 1;
    wait_us(10);
}

void displayInit() {
    beginSend();

    // Remap & Color depth setting
    sendCommand(0xA0);
    sendData(0x30);

    // Dim mode
    sendCommand(0xAB);
    sendData(0x00);    // reserved(0x00)
    sendData(0x7F);    // R
    sendData(0x7F);    // G
    sendData(0x7F);    // B
    sendData(0x10);    // precharge
    
    // Enable linear grayscale table
    sendCommand(0xB9);

    // Display On
    sendCommand(0xAF);

    endSend();
}

void fill(byte R, byte G, byte B) {
    beginSend();
    sendCommand(0x26);
    sendData(0x01);
    endSend();
    fillR = R;
    fillG = G;
    fillB = B;
    color = fillB & 0b11100000 | (fillG >> 3) & 0b00011100 | (fillR >> 6) & 0b00000011;
}
void nofill() {
    beginSend();
    sendCommand(0x26);
    sendData(0x00);
    endSend();
}
void setColor(byte R, byte G, byte B) {
    fillR = R;
    fillG = G;
    fillB = B;
    color = fillB & 0b11100000 | (fillG >> 3) & 0b00011100 | (fillR >> 6) & 0b00000011;
}

void drawLine(byte x1, byte y1, byte x2, byte y2, byte R, byte G, byte B) {
    beginSend();
    sendCommand(0x21);
    sendData(x1);  //x1
    sendData(y1 + 0x04);  //y1
    sendData(x2);  //x2
    sendData(y2 + 0x04);  //y2 83
    sendData(R);  //foregroundColor3
    sendData(G);  //2
    sendData(B);  //1
    endSend();
}

void commitTilebuffer_h(const byte * tils, byte * tb_h) {
    for(int iy=0; iy<TL_HEIGHT; iy++) {
        // Send padding pixel
        sendData(0x00);
        sendData(0x00);
        for(int tx=0; tx<TL_HORZ; tx++) {
            // Scan each line of tiles in a column
            const byte * t_ptr = tils + (tb_h[tx]*TL_WIDTH);
            byte line = 0;
            for(int i=0; i<TL_WIDTH; i++) {
                line <<= 1;
                line |= (t_ptr[i] >> (TL_HEIGHT - iy - 1)) & 0b1;
            }
            for(int i=0; i<TL_WIDTH; i++) {
                if(line & (0b1 << (TL_WIDTH - i - 1))) {
                    sendData(color);
                } else {
                    sendData(0x00);
                }
            }
        }
        // Send padding pixel
        sendData(0x00);
        sendData(0x00);
    }
}

void commitTilebuffer(const byte * tils, byte * tb) {
    // Set column addr.
    beginSend();
    sendCommand(0x15);
    sendData(0x00);   // start
    sendData(0x9F);   // end

    // Set row addr.
    sendCommand(0x75);
    sendData(0x04);   // start
    sendData(0x83);   // end

    // Write to GDDRAM
    sendCommand(0x5C);
    for(int ty=0; ty<TL_VERT; ty++) {
        commitTilebuffer_h(tils, tb + TL_HORZ*ty);
    }
  
    endSend();
}

void clearTilebuffer(byte * tb) {
    for(int i=0; i<TL_HORZ*TL_VERT; i++) {
        tb[i] = 0;
    }
}

void clearScreen() {
    byte blank_tile[] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
    clearTilebuffer(tilebuf);
    commitTilebuffer(blank_tile, tilebuf);
}

void setTile(byte * tb, byte tx, byte ty, byte t_id) {
    tb[tx + TL_HORZ*ty] = t_id;
}

void blitString(byte * tb, byte tx, byte ty, const char * str) {
    byte d_x = tx;
    for(int i = 0; str[i] != '\0'; i++) {
        setTile(tb, d_x, ty, (byte)str[i]);
        d_x += 1;
        if(d_x >= TL_HORZ) break;
    }
}


int main() {
    // initialize
    spi.format(8, 3);
    spi.frequency(24000000);
    
    cs_pin = 1;
    
    // force reset
    nres_pin = 1;
    wait_us(100);
    nres_pin = 0;
    wait_us(100);
    nres_pin = 1;
    wait(1);
    
    // initialize the display
    displayInit();
    
    // clear screen
    clearScreen();
    
    
    // Set color and fill
    fill(0, 255, 255);
    
    // Test code below!
    char mes[32];
    AnalogIn adc0(P0_23);
    
    Timer frame_timer;
    frame_timer.reset();
    while(1) {
        frame_timer.start();
        
        clearTilebuffer(tilebuf);
        
        blitString(tilebuf, 0, 0, "bocomo");
        setTile(tilebuf, 6, 0, 0x1B);
        setTile(tilebuf, 7, 0, 0x1F);
        setTile(tilebuf, 25, 0, 0x0B);
        
        for(int i=0; i<TL_HORZ; i++) {
            setTile(tilebuf, i, 1, 0x06);
        }
        
        blitString(tilebuf, 1, 6, "Hello, World!!");
        sprintf(mes, "ADC0: %f", adc0.read());
        blitString(tilebuf, 1, 8, mes);
        
        commitTilebuffer(tiles, tilebuf);
        frame_timer.stop();
        int f_busy_time = frame_timer.read_ms();
        int frame_wait_time = 1000 / FPS - f_busy_time;
        if(frame_wait_time > 0) {
            wait_ms(frame_wait_time);
        }
        
        frame_timer.reset();
    }
}
