#include "mbed.h"

#define TERMINATOR  '\n'
#define SEPARATOR   ','
#define OFFSET 500 //mV
#define RECEIVER_COUNT 5
#define BUTTON_COUNT 4

// Analog input solar cells corresponding to digital output leds.
/*
DigitalOut red_leds[5] = {PC_10, PC_12, PA_13, PA_14, PA_15};
DigitalOut green_leds[5] = {PB_7, PC_13, PC_14, PC_15, PH_0};
DigitalOut blue_leds[5] = {PH_1, PC_2, PC_3, PC_11, PD_2};
*/

DigitalOut red_leds[] = {PB_9, PB_6, PA_8, PB_5, PC_4};
DigitalOut green_leds[] = {PA_6, PC_7, PB_10, PB_3, PB_13};
DigitalOut blue_leds[] = {PA_5, PA_7, PA_9, PB_4, PA_10};

//DigitalIn buttons[] = {PA_3, PA_2, PA_10, PB_3};     //order: easy, medium, hard, expert
DigitalIn buttons[] = {PC_10, PC_12, PA_13, PA_14};
bool buttons_state[BUTTON_COUNT];
bool buttons_state_prev[BUTTON_COUNT] = {1, 1, 1, 1};

AnalogIn solarCells[] = {PC_1, PB_0, PA_4, PA_1, PA_0};
bool solarCellsState[RECEIVER_COUNT];
uint16_t solarCellsThreshold[RECEIVER_COUNT];
int active_receivers[RECEIVER_COUNT] = {0, 0, 0, 0, 0};
int prev_state[RECEIVER_COUNT] = {0, 0, 0, 0, 0};
//float initialValues[RECEIVER_COUNT];

Serial serial(PA_2, PA_3);
//Serial serial(PA_11, PA_12);

int level_static;

char pcBuffer[256];
uint8_t pcBufferIndex = 0;
bool messageReceived = false;

enum States {
    IDLE,
    CALIBRATE,
    START,
    RUNNING,
    STOP,
    MAX_STATES
};

enum States state = CALIBRATE;
//enum States state = START;

/*
void callback(void) {
    pcBuffer[pcBufferIndex] = serial.getc();
    
    if(pcBuffer[pcBufferIndex] == TERMINATOR) {
        pcBufferIndex = 0;
        messageReceived = true;
    }
}
*/

void EnablePullups(void) {
    /*
    for (uint8_t i = 0; i > (sizeof(buttons)); i++) {
        buttons[i].mode(PullUp);    
    }
    */
    //serial.printf("Pullup functions");
    buttons[0].mode(PullUp);
    buttons[1].mode(PullUp);
    buttons[2].mode(PullUp);
    buttons[3].mode(PullUp);
    
}

int ReadSolarCell(int index) {
    //check all analog channels and set digital channels appropriately
    //for(int i = 0; i < sizeof(solarCells); i++) {
        //find channels current value
        float meas;
        meas = solarCells[index].read(); // Converts and read the analog input value (value from 0.0 to 1.0)
        meas = meas * 3300; // Change the value to be in the 0 to 3300 range
        //serial.printf("measure %d = %.0f mV\n", index, meas);
        if (meas > solarCellsThreshold[index]) { // If the value is greater than 2V then switch the LED on
          return 1;
        }
        else {
          return 0;
        }
    //}
}

void PuzzleSelector(int level) {    
    level_static = level; //so the level can be accessed in other functions
    
    for (int i = 0; i < RECEIVER_COUNT; i++) {
        active_receivers[i] = 0;
    }
        
    if (level == 2) {
        //myInt1 = rand() % (max_number + 1 - min_number) + min_number;  //debug
        
        for (int i = 0; i < 1; i++) {
            active_receivers[i] = 1;
        }
        serial.printf("e");
    }
    else if (level == 3) {
        for (int i = 0; i < 2; i++) {
            active_receivers[i] = 1;
        }
        serial.printf("m");
    }
    else if (level == 1) {
        for (int i = 0; i < 3; i++) {
            active_receivers[i] = 1;
        } 
        serial.printf("h");
    }
    else {
        for (int i = 0; i < 4; i++) {
            active_receivers[i] = 1;
        }
        serial.printf("x");
    }
    
    //return active_receivers;
}

//DigitalOut test(D0);

int main() {
    EnablePullups();
    
    bool buttonPressed = false;
    
    for(uint8_t i = 0; i < RECEIVER_COUNT; i++) {
        solarCellsState[i] = false;
        solarCellsThreshold[i] = 0;        
    }
    
    while(true) {
        
        /*while(true) {
            for (uint8_t i = 0; i < 5; i++) {
                    red_leds[i] = 1;
                    blue_leds[i] = 0;
                    green_leds[i] = 0;
                    //test = 1;
            }
        }*/
        
        switch(state) {
            case IDLE: {
                //serial.printf("State = IDLE\n\r"); 
                while(serial.getc() != 's');
                
                for (uint8_t i = 0; i < RECEIVER_COUNT; i++) {
                    red_leds[i] = 0;
                    blue_leds[i] = 0;
                    green_leds[i] = 0;
                }
                 
                while (buttonPressed == false) {
                       for (uint8_t i = 0; i < BUTTON_COUNT; i++) {
                               //serial.printf("Waiting for button...\n");
                               //while (loopcount < 100) {
                               buttons_state[i] = buttons[i].read();
                               //serial.printf("Button %i state is %i\n\r", i, buttons_state[i]);
                               wait(0.05);
                               //loopcount = loopcount++;
                               //buttonPressed = true;
                               //}
                               if (buttons_state[i] == 0) {
                                   //serial.printf("Button %i pressed\n\r", i);
                                   //call puzzle selector function
                                   PuzzleSelector(i);
                                   buttonPressed = true;
                                }
                        }
                }
                buttonPressed = false;
                state = START;
                break;
            }
                
            case CALIBRATE: {
                //serial.printf("State = CALIBRATE\n\r");                 
                //calibrate to ambient light, adding offset to find the thresholds
                for(int i = 0; i < RECEIVER_COUNT; i++) {
                    //serial.printf("i= %i",i);
                    solarCellsThreshold[i] = (solarCells[i].read() * 3300) + OFFSET;
                    //serial.printf("initial %d = %.0f mV\n", i, solarCellsThreshold[i]);
                }
                
                state = IDLE;
                
                break; 
            }
            
            case START: {
                //serial.printf("State = START\n\r");
                //serial.printf("%c", TERMINATOR);
                for (uint8_t i = 0; i < RECEIVER_COUNT; i++) {
                    if (active_receivers[i] == 1) {
                        red_leds[i] = 1;
                        blue_leds[i] = 0;
                        green_leds[i] = 0;
                    }
                    else {
                        red_leds[i] = 0;
                        blue_leds[i] = 0;
                        green_leds[i] = 0;
                    }
                }
                state = RUNNING;
                break;
            }
            
            case RUNNING: {
                //serial.printf("State = RUNNING\n\r");
                // Update solarCellsState.
                for(uint8_t i = 0; i < RECEIVER_COUNT; i++) {
                    solarCellsState[i] = 0;
                }
                
                for(uint8_t i = 0; i < RECEIVER_COUNT; i++) {
                    if(active_receivers[i]) {
                        //solarCellsState[i] = (solarCells[i].read() >= solarCellsThreshold[i]);
                        solarCellsState[i] = ReadSolarCell(i);
                        green_leds[i] = solarCellsState[i];
                        red_leds[i] = !solarCellsState[i];
                    }
                }
                bool test = 1;
                for(uint8_t i = 0; i < RECEIVER_COUNT; i++) {
                    test &= (active_receivers[i] == solarCellsState[i]);
                }
                if(test == 1) {
                    state = STOP;
                }
                break;
            }
            case STOP: {  
                
                serial.printf("z");
                state = IDLE;
                break;
            }
                
            default: {
                break;
            }      
        }
    } //while loop parethesis
} //main parenthesis

