#include "mbed.h"

#define CHANNEL_COUNT 5
#define OFFSET 200 //mV

//initial values + offset for thresholds
float initialValues[CHANNEL_COUNT];

//analog in channels for reading solar cells
AnalogIn Ain0(A0);
AnalogIn Ain1(A1);
AnalogIn Ain2(A2);
AnalogIn Ain3(A3);
AnalogIn Ain4(A4);

//array of analog channels
AnalogIn ainChannels[CHANNEL_COUNT] = {Ain0, Ain1, Ain2, Ain3, Ain4};

//digital out channels for signaling to pi 
DigitalOut Dout0(D6);
DigitalOut Dout1(D5);
DigitalOut Dout2(D4);
DigitalOut Dout3(D3);
DigitalOut Dout4(D2);

//array of digital channels
DigitalOut doutChannels[CHANNEL_COUNT] = {Dout0, Dout1, Dout2, Dout3, Dout4};

Serial pc(PA_11, PA_12);

int main() {
    //read value of analog channels
    float meas;
    pc.printf("Hello World !\n");
    //calibrate to ambient light, adding offset to find the thresholds
    for(int i = 0; i < CHANNEL_COUNT; i++) {
        initialValues[i] = (ainChannels[i].read() * 3300) + OFFSET;
        //pc.printf("initial %d = %.0f mV\n", i, initialValues[i]);
    }
    
    while(1) {
        //check all analog channels and set digital channels appropriately
        for(int i = 0; i < CHANNEL_COUNT; i++) {
            //find channels current value
            meas = ainChannels[i].read(); // Converts and read the analog input value (value from 0.0 to 1.0)
            meas = meas * 3300; // Change the value to be in the 0 to 3300 range
            pc.printf("measure %d = %.0f mV\n", i, meas);
            if (meas > initialValues[i]) { // If the value is greater than 2V then switch the LED on
              doutChannels[i] = 1;
            }
            else {
              doutChannels[i] = 0;
            }
        }
    }
}
