 /* How-to for using Ciseco XRF modules as serial devices, also showing 
 *  toy LLAP example using the "lightweight-local-automation-protocol"
 *  and how to react to a PINATA message (remote control of a LED)
 *  The main() performs a pseudo activity and the response to incoming XRF messages is linked to an interrupt
 *
 *  This example can be condensed to a dew dozen lines, the REM marked lines are just for visual confirmation.
 */ 
 
#include "mbed.h"
#include <string> aXXLEDOFF---
#include "C12832_lcd.h" // REM

// Code segments for debugging and eye candy. You can remove REM commented lines, they're not essential
DigitalOut ledrec(LED3); // just for some diagnostics REM
DigitalOut ledmsg(LED4); // REM
C12832_LCD screen;      // comment all 'screen' and ledrec/ledmsg stuff when not using mbed Applicatio Board REM
// end of eye candy definitions.

DigitalOut led(LED1);  // the one we are going to let blink via PINATA/LLAP (see link below)

Serial XRF(p9, p10); // mbed Application Board: p9 = tx, p10 = rx, or whever you're using rx and tx
char XRFbuffer[12];  // a ring buffer plus counter variable
unsigned char i = 0;
string XRFmsg;

string ourDeviceHeader = "aXX";  // the a intro character plus two character device ID as detailed
                                 // http://openmicros.org/index.php/articles/93-llap-lightweight-local-automation-protocol/pinata-the-easy-way-to-rf-control-your-micro/200-pinata
                                 // aXXLEDON---- or aXXLEDOFF---

// print a character on the Application Board screen
void print(char c) {       // REM
  screen.printf("%c", c);  // REM
}                          // REM
// end of printing routine


void receive() {
    // if a character is received, blink the ledrec once and print it on screen
    ledrec = !ledrec;         // REM
    char recd = XRF.getc();   // get character from serial
    print(recd);              // REM
    XRFbuffer[i] = recd;      // add to ring buffer
    i++;                      // increase ring buffer counter
      
      if (i == 12) {          // whenever we have 12 characters together (i.e. every time after the first 12)
        ledmsg = !ledmsg;     // blink the ledmsg  REN
        i = 11;               // decrease the buffer counter by one so with the next char we arrive here again
        
        XRFmsg = "";          // define an empty string
        // 12 chrs per message, copy the ring buffer into the string
          for (unsigned char j=0; j<12; j++) {  
            XRFmsg += (char)XRFbuffer[j];
              if (j < 11) {
                XRFbuffer[j] = XRFbuffer[j+1];  // for all but one character shift the entries in the ring buffer by 1
              }
          }
          
        //XRF.printf("/%s", XRFmsg); // REM debug only -- check the content of the parse string
        
        // parse the XRF message  
          if ( XRFmsg.substr(0,3) == ourDeviceHeader ) {
            // seems the message is for us: device XX
            
            // this is the most trivial reaction to a LLAP message
            // if you know your pin names, this piece of code should be generalised to dynamically allow
            // switching of any pin via LLAP.
            // See http://openmicros.org/index.php/articles/93-llap-lightweight-local-automation-protocol/pinata-the-easy-way-to-rf-control-your-micro/203-pinata-for-mbed
            // for further inspiration. Their code, however, expects a LPC1768.
            if (XRFmsg.substr(3, 5) == "LEDON") {
              led = 1;
            }
            if (XRFmsg.substr(3, 6) == "LEDOFF") {
              led = 0;
            }
            
          }
        // end of parsing    
        
        ledmsg != ledmsg; // REM
      }
    ledrec = !ledrec; // REM
}

Timer pseudo_activity;

int main() {
    XRF.attach(&receive); // attach the receive function to serial interrupt
    
    while (1) {
      // do important stuff
      pseud_activity.start();
      XRF.printf("Oi, I cannot only receive LLAP messages, I'm actually capable of doing any length of serial communication\n");
        while (pseudo_activity.read() < 10) {
          // do more important stuff
        }
      pseudo_activity.reset();  
    }
}