#include "Bird.h"




// Objects
N5110 lcd(PTC9,PTC0,PTC7,PTD2,PTD1,PTC11);
Gamepad pad;
Bird bird;

// Prototypes
void init();
void welcome();
void mode1();
void start(int fps);
void play(int fps);
void failure();



int main()
{
    // set the frame per second
    int fps = 5;
    // first need to initialise the display
    init();
    // these are default settings so not strictly needed
    lcd.normalMode();      // normal colour mode
    lcd.setBrightness(0.6); // put LED backlight on 60%
    // change set contrast in range 0.0 to 1.0
    // 0.5 appears to be a good starting point
    lcd.setContrast(0.5);      
    lcd.clear();

    // welcome screen that waiting the player to  start
    welcome();
    // Mode choosing, to determine the barrier speed
    mode1();

    // game start, draw the bird and the barrier
    start(fps);
    
    while(1){
        // playing procedure
        play(fps);
    
    // failure screen, to ask user to play again 
        failure();
    
    }
    
    
}

void init()
{
    // initialise lcd and gamepad
    lcd.init();
    pad.init();
    bird.init();
}

void welcome()
{
    // print welcome screen 
    bird.welcome(lcd);
    lcd.refresh();
    
    // move to game while start button is pressed
    while ( pad.check_event(Gamepad::START_PRESSED) == false) {
        pad.leds_on();
        wait(0.1);
        pad.leds_off();
        wait(0.1);
    }
}

void mode1()
{      
    // choosing difficulty
    while (pad.check_event(Gamepad::A_PRESSED) == false) {
    bird.mode(lcd, pad);
    }
}

void start(int fps)
{
    // draw the first bird and barrier, 
    // and giving the last 3 seconds to prepare
    bird.ready(lcd);

}

void play(int fps)
{
    lcd.clear(); 
    if(pad.check_event(Gamepad::A_PRESSED)){
    bird.flyup(lcd);    
    }
    else {bird.flydown(lcd);}
    bird.barrier(lcd);
    bird.score(lcd);
    bird.pause(lcd,pad); 
    lcd.refresh();
    wait(1.0/fps); 
}

void failure()
{
    bird.fail(lcd, pad);
}