#include "mbed.h"
#include "EthernetInterface.h"
#include "cJSON.h"

DigitalInOut myIOD10(D10);
DigitalIn myInD11(D11);
DigitalOut myOutD12(D12);
AnalogIn myInA1(A1);
int socketPort = 8000;
int httpPort = 80;

Serial pc(PA_13,PA_14);

int MallocSize = 800*sizeof(char);
//bool socket_GET(TCPSocketConnection &conn);
bool http_GET(TCPSocketConnection &conn);
bool http_POST(TCPSocketConnection &conn,int vall);
//bool socket_POST(TCPSocketConnection &conn,int vall);
//bool closeConnect(TCPSocketConnection &conn);
void receive_dht11();
unsigned char receive_byte();
void button_led();
Timeout receive_dht11Timeout;
Timeout button_ledTimeout;

void delay(unsigned char ms)
{ 
    unsigned int y;
    while(ms--)
        for(y=1920; y>0; y--);
}

void Delay_us(unsigned char us)
{
    unsigned char y;
    while(us--)
        for(y=2; y>0; y--);
}

float val;
bool out=false;
unsigned char RH,RL,TH,TL;
unsigned char data_byte;
unsigned int  U8FLAG;
static unsigned char num = 4;
const char receive_module[4][5] = {"Led", "Gas", "Hum", "Temp", };
#if 1
int main() { 
    int phy_link;
    pc.printf("Wait a second...\r\n");
    uint8_t mac_addr[6] = {0x78, 0x08, 0xDC, 0x1c, 0xa8, 0x95}; 
    receive_dht11Timeout.attach(&receive_dht11,0.2f);
    button_ledTimeout.attach(&button_led,0.1f);
    
    EthernetInterface eth;
    eth.init(mac_addr); //Use DHCP
    eth.connect();
    pc.printf("start IP Address is %s\r\n", eth.getIPAddress());
    
    do{
        phy_link = eth.ethernet_link();
        pc.printf("...");
        pc.printf("phy_link=%d...", phy_link);
        wait(2);
    }while(!phy_link);
    printf("\r\n");
    
    pc.printf("IP Address is %s\r\n", eth.getIPAddress());

    TCPSocketConnection conn;
    while(true)
    {   
        //wait(0.5f);
        if(num)
        {
            if (num == 4)
                val = TH;
            else if (num == 3)
                val = RH;
            else if (num == 2)
                val = myInA1.read_u16();
            else if (num == 1)
                val = myOutD12.read();
        }
        //int mathtest = ceil(val);//math.
        pc.printf("start http_post\r\n");
        wait(1);
        
        conn.connect("iot.espressif.cn", httpPort);

        http_POST(conn, val);
        
        conn.close();
        val = 0.0;  
        //mathtest = 0; 
        
        if(out)break;
    }
    
    //conn.close();            
    eth.disconnect();
    pc.printf("out the program!\r\n");
    return 0;                     
}
#else

int main() { 
    pc.printf("Wait a second...\r\n");
    uint8_t mac_addr[6] = {0x78, 0x08, 0xDC, 0x1c, 0xa8, 0x95}; 
    
    EthernetInterface eth;
    eth.init(mac_addr); //Use DHCP
    eth.connect();
    pc.printf("start IP Address is %s\r\n", eth.getIPAddress());
    eth.ethernet_link();
    pc.printf("IP Address is %s\r\n", eth.getIPAddress());

    TCPSocketConnection conn;
    
    
    while(true)
    {   
        int ret = 0;
        pc.printf("start http_post\r\n");
        //ret = conn.connect("192.168.1.41", 10086);
        ret = conn.connect("iot.espressif.cn", httpPort);
        
        pc.printf("connect ret=%d\n",ret);
        ret = conn.send_all("asdfghh", 7);//http_cmd for http,pJSON for 
        pc.printf("send ret=%d\n",ret); 
        wait(1.0f);
        ret = conn.close();
        pc.printf("close ret=%d\n",ret);  
        wait(1.0f);
    }
    
           
    eth.disconnect();
    pc.printf("out the program!\r\n");
    return 0;                     
}

#endif
/*http POST*/
bool http_POST(TCPSocketConnection &conn, int val)
{
    pc.printf("%s():%d\n",__FUNCTION__, __LINE__);
    //wait(0.5);
    /*if(conn.is_connected()){
        pc.printf("connect is already ok!\r\n");    
    }else{pc.printf("%s():%d\n",__FUNCTION__, __LINE__);
        if(!conn.connect("iot.espressif.cn", httpPort)) //80 for http,8000 for socket
            pc.printf("connect OK!\r\n");
        else{
            pc.printf("connct ERR!\r\n");
            out = true;
            return false;    
        }
    }*///conn.connect("iot.espressif.cn", httpPort);
    
    cJSON* http_post=NULL;  
    http_post = cJSON_CreateObject();    
    if(NULL == http_post)
    {
         pc.printf("OUT4\r\n");
         out = true;
         return false;
    }
    
    cJSON* http_post_json=NULL;  
    http_post_json = cJSON_CreateObject();    
    if(NULL == http_post_json)
    {
         cJSON_Delete(http_post);
         pc.printf("OUT5\r\n");
         out = true;
         return false;
    }
    cJSON_AddNumberToObject(http_post_json, "x", val);
    //cJSON_AddNumberToObject(http_post_json, "y", 2);
    //cJSON_AddNumberToObject(http_post_json, "z", 2);
    cJSON_AddItemToObject(http_post, "datapoint", http_post_json);
    char* pJSON_http_post = cJSON_PrintUnformatted(http_post);
    
    if(NULL == pJSON_http_post)
    {
        cJSON_Delete(http_post);
        pc.printf("OUT6\r\n");
        out = true;
        return false;
    }
    
    //Pay attention to out of memory
    //char http_POST_cmd[500] = "POST /v1/datastreams/jhtest/datapoint/ HTTP/1.1\r\nUser-Agent: curl/7.22.0 (i686-pc-linux-gnu) libcurl/7.22.0 OpenSSL/1.0.1 zlib/1.2.3.4 libidn/1.23 librtmp/2.3\r\n"\
                     // "Host:iot.espressif.cn\r\nAccept: */*\r\nAuthorization: token ebe1671e9d9f42a5231d017ec550552b9bae2cdf\r\n"\
                     // "Content-Length: 33\r\nContent-Type: application/x-www-form-urlencoded\r\n\r\n";
    char http_POST_cmd[500];// = "POST /v1/datastreams/test/datapoint/ HTTP/1.1\r\nUser-Agent: curl/7.22.0 (i686-pc-linux-gnu) libcurl/7.22.0 OpenSSL/1.0.1 zlib/1.2.3.4 libidn/1.23 librtmp/2.3\r\n"\
    //                  "Host:iot.espressif.cn\r\nAccept: */*\r\nAuthorization: token b1e92cf17fe4482647924941949ab2b07ffab548\r\n"\
    //                  "Content-Length: ";
    sprintf(http_POST_cmd,"POST /v1/datastreams/%s/datapoint/ HTTP/1.1\r\nUser-Agent: curl/7.35.0\r\n"\
                      "Host:iot.espressif.cn\r\nAccept: */*\r\nAuthorization: token b1e92cf17fe4482647924941949ab2b07ffab548\r\n"\
                      "Content-Length: ", receive_module[num-1]);
    num--;
    if (num == 0)
        num = 4;
        
    char len[2]; 
    len[0]=strlen(pJSON_http_post)/10%10+48;
    len[1]=strlen(pJSON_http_post)%10+48;
    strcat(http_POST_cmd,len);
    strcat(http_POST_cmd,"\r\nContent-Type: application/x-www-form-urlencoded\r\n\r\n");
     
    strcat(http_POST_cmd,pJSON_http_post);
    conn.send_all(http_POST_cmd, strlen(http_POST_cmd));//http_cmd for http,pJSON for socket,should be three changes
    pc.printf("%s\r\n",http_POST_cmd); 
    
    char *buffer = NULL;
    buffer = (char *)malloc(MallocSize);
    if(!buffer)pc.printf("malloc buffer err\r\n");

    /*int ret;
    pc.printf("6666\r\n");
    while (true) 
    {
        wait(1);pc.printf("%s():%d\n",__FUNCTION__, __LINE__);
        ret = conn.receive_all(buffer, MallocSize-1);pc.printf("%s():%d\n",__FUNCTION__, __LINE__);
        pc.printf("ret = %d\r\n",ret);
        if (ret <= 0) {
            ;//break;
        }
        buffer[ret] = '\0';
        pc.printf("Received %d chars from server: %s\n", ret, buffer);     
    }*/
    pc.printf("http_POST OUT\r\n");

    free(pJSON_http_post);
    free(buffer);
    cJSON_Delete(http_post);
    
    return true;
}

/*http_GET*/
bool http_GET(TCPSocketConnection &conn)
{
    if(conn.is_connected()){
        pc.printf("connect is already ok!\r\n");    
    }else{
        if(!conn.connect("iot.espressif.cn", httpPort)) //80 for http,8000 for socket
            pc.printf("connect OK!\r\n");
        else{
            pc.printf("connct ERR!\r\n");
            out = true;
            return false;    
        }
    }
    
    char http_cmd[] = "GET /v1/datastreams/Led/datapoint/ HTTP/1.1\r\nUser-Agent: curl/7.22.0 (i686-pc-linux-gnu) libcurl/7.22.0 OpenSSL/1.0.1 zlib/1.2.3.4 libidn/1.23 librtmp/2.3\r\n"\
                      "Host:iot.espressif.cn\r\nAccept: */*\r\nAuthorization: token b1e92cf17fe4482647924941949ab2b07ffab548\r\n\r\n";
    
    conn.send_all(http_cmd, strlen(http_cmd));//http_cmd for http,pJSON for socket,should be three changes
    pc.printf("%s\r\n",http_cmd);
    
    //char *buffer = NULL;
    //buffer = (char *)malloc(MallocSize);
    //if(!buffer)pc.printf("malloc buffer err\r\n");
    char buffer[500];
    int ret;

    while (true) {
        wait(1);
        ret = conn.receive(buffer, 500-1);
        pc.printf("ret = %d\r\n",ret);
        if (ret <= 0) {
            break;
        }
        buffer[ret] = '\0';
        pc.printf("Received %d chars from server: %s\n", ret, buffer);     
    }
    pc.printf("http_GET OUT\r\n");
    /* 
    if(conn.close()){
        pc.printf("conn.close OK\r\n");    
    }else{
        pc.printf("conn.close ERR\r\n");    
    }
    */
    //free(buffer);
    return true;
}

unsigned char receive_byte()
{
    unsigned char i,temp;
    for(i=0;i<8;i++)
    {
        U8FLAG = 2;
        while(!myIOD10.read() && U8FLAG++);
        Delay_us(30);
        temp=0;
        if(myIOD10.read()==1)
        temp=1;
        U8FLAG = 2;
        while(myIOD10.read() && U8FLAG++);
        
        if(U8FLAG==1)break;
        data_byte<<=1;//
        data_byte|=temp;
    }
    return data_byte;
}

void receive_dht11()
{
    unsigned char T_H,T_L,R_H,R_L,check,num_check;
    
   
    myIOD10.output();
    myIOD10.write(0);
    delay(20);
    
    myIOD10.write(1);
    Delay_us(25);
    myIOD10.write(1);
    
    myIOD10.input();
    if(!myIOD10.read())
    {
        while(!myIOD10.read());
        while(myIOD10.read());
        R_H=receive_byte();
        R_L=receive_byte();
        T_H=receive_byte();
        T_L=receive_byte();
        check=receive_byte();
        //pc.printf("--R_H--%d---R_L---%d--T_H--%d---T_L---%d\r\n", R_H,R_L,T_H,T_L);
        Delay_us(20);
        num_check=R_H+R_L+T_H+T_L;//pc.printf("--num_check--%d---check---%d\r\n", num_check,check);
        if(num_check==check)
        {
            RH=R_H;
            RL=R_L;
            TH=T_H;
            TL=T_L;
            check=num_check;
        }
    }
    
    //pc.printf("humidity [H] -out--%d\r\n", RH);
    //pc.printf("humidity [L] -out--%d\r\n", RL);
    //pc.printf("temperature [H] -out--%d\r\n", TH);
    //pc.printf("temperature [L] -out--%d\r\n", TL);
    
    receive_dht11Timeout.attach(&receive_dht11,0.2f);
}

void button_led()
{  
    while(myInD11.read())
    {
        wait(0.01f);
        if(!myInD11.read())
        {
            myOutD12.write(!myOutD12.read());
            break;
        }
    }
    
    button_ledTimeout.attach(&button_led,0.1f);
}
