#include "mbed.h"
#include "EthernetInterface.h"
#include "wizHTML.h"
#include <stdio.h>
#include <string.h>


#define MAC     "\x00\x08\xDC\x11\x34\x78"
#define IP      "192.168.1.12"
#define MASK    "255.255.255.0"
#define GATEWAY "192.168.1.1"

#define HTTPD_SERVER_PORT   80
#define HTTPD_MAX_REQ_LENGTH   102
#define HTTPD_MAX_HDR_LENGTH   96
#define HTTPD_MAX_FNAME_LENGTH   127
#define HTTPD_MAX_DNAME_LENGTH   127


Serial uart(PA_13,PA_14);
DigitalInOut myIOD10(D10);
DigitalIn myInD11(D11);
DigitalOut myOutD12(D12);
AnalogIn myInA1(A1);
Timeout buttonLedTimeout;
Timeout receiveDht11Timeout;

unsigned char RH,RL,TH,TL;
unsigned char data_byte;
unsigned int  U8FLAG;
char seaver_ip[] = IP;
char led_control[6];
unsigned int loopCnt = 10000;

EthernetInterface eth;
TCPSocketServer server;
TCPSocketConnection client;

char buffer[HTTPD_MAX_REQ_LENGTH+1];
char httpHeader[HTTPD_MAX_HDR_LENGTH+1];
char fileName[HTTPD_MAX_FNAME_LENGTH+1];
char dirName[HTTPD_MAX_DNAME_LENGTH+1];
char *uristr;
char *eou;
char *qrystr;

void receiveDht11();
unsigned char receiveByte();

void buttonLed()
{  
    while(myInD11.read())
    {
        wait(0.01f);
        if(!myInD11.read())
        {
            myOutD12.write(!myOutD12.read());
            break;
        }
    }
    
    buttonLedTimeout.attach(&buttonLed,0.1f);
}

void getFile(char* uri)
{
    static char string_c[24] = {0};
    char* Led;
    char* ledS;
    int gas = myInA1.read_u16();
    uart.printf("getFile %s\n", uri);
    if(memcmp(&uri[1], "favicon.ico", 11)==0){
        return;
    }
    strncpy(led_control, &uri[1], 5);
    char *lstchr = strrchr(uri, NULL) -1;
    
    static char open_1 = 1, cloce_1 = 1;
    if (memcmp(led_control, "offon", 5)==0){
        if (cloce_1){
            myOutD12.write(0);   
            cloce_1 = 0;
        }
        
        open_1 = 1;
     }
     else if (memcmp(led_control, "onoff", 5)==0){
        if (open_1){
            myOutD12.write(1);
            open_1 = 0;
        }
        
        cloce_1 = 1;
    }
    if(myOutD12.read()){
        Led  = ledSc[0];
        ledS = ledSc[1];
        sprintf(string_c,"%s/offon", seaver_ip);
    }else{
        Led  = ledSc[2];
        ledS = ledSc[3];  
        sprintf(string_c,"%s/onoff", seaver_ip);  
    }
    htmlWeb(TH, TH*5, RH, RH*5, gas, gas*0.05f, Led, ledS, string_c);
    sprintf(httpHeader,"HTTP/1.1 200 OK\r\nContent-Type: text/html\r\nConnection: Close\r\n\r\n");
    client.send(httpHeader,strlen(httpHeader));
    
    for (int i=0; i<sizeof(html); i += 96){
        memcpy(httpHeader, &html[i], 96);
        client.send(httpHeader,strlen(httpHeader));
        //wait(0.00001);
    }
    
    memset(string_c, 0, sizeof(string_c));
    memset(html, 0, sizeof(html));
}

int main (void)
{
    uart.baud(115200);
    uart.printf("Initializing\r\n");
    uart.printf("Initializing Ethernet\r\n");
    buttonLedTimeout.attach(&buttonLed,0.1f);
    receiveDht11Timeout.attach(&receiveDht11,0.2f);
    while (true) {
        //eth.init(); //Use DHCP
        eth.init((uint8_t*)MAC,IP,MASK,GATEWAY);  //IP,mask,Gateway
        uart.printf("Connecting\r\n");
        eth.connect();
        uart.printf("IP Address is %s\r\n", eth.getIPAddress());

        server.bind(HTTPD_SERVER_PORT);
        server.listen();
        uart.printf("Server Listening\r\n");

        while (true) {
            uart.printf("\nWait for new connection...\r\n");
        
            client.set_blocking(false, 500); // Timeout after (0.5)s
            server.accept(client);

            uart.printf("Connection from: %s\r\n", client.get_address());
            while (true) {
                int n = client.receive(buffer, sizeof(buffer));
                if (n <= 0) {
                    uart.printf("return value n<=0\n");
                    break;
                }
                uart.printf("Recieved Data: %d\r\n\r\n%.*s\r\n",n,buffer);
                if (n >= 1024) {
                    sprintf(httpHeader,"HTTP/1.1 413 Request Entity Too Large \r\nContent-Type: text\r\nConnection: Close\r\n\r\n");
                    client.send(httpHeader,strlen(httpHeader));
                    client.send(buffer,n);
                    break;
                } else {
                    buffer[n]=0;
                }
                if (!memcmp(buffer, "GET ", 4)) {
                    uristr = buffer + 4;
                    eou = strstr(uristr, " ");
                    if (eou == NULL) {
                        sprintf(httpHeader,"HTTP/1.1 400 Bad Request \r\nContent-Type: text\r\nConnection: Close\r\n\r\n");
                        client.send(httpHeader,strlen(httpHeader));
                        client.send(buffer,n);
                    } else {
                        *eou = 0;
                        getFile(uristr);
                    }
                }
            }
            client.close();
            break;
        }
    }
}

unsigned char receiveByte()
{
    unsigned char i,temp;
    for(i=0;i<8;i++)
    {
        U8FLAG = 2;
        loopCnt = 10000;
        while(!myIOD10.read() && U8FLAG++){
            if (loopCnt-- == 0) return 2;    
        }
        wait(0.00003f);
        temp=0;
        if(myIOD10.read()==1)
        temp=1;
        U8FLAG = 2;
        loopCnt = 10000;
        while(myIOD10.read() && U8FLAG++){
            if (loopCnt-- == 0) return 2;    
        }
        
        if(U8FLAG==1)break;
        data_byte<<=1;
        data_byte|=temp;
    }
    return data_byte;
}

void receiveDht11()
{
    unsigned char T_H,T_L,R_H,R_L,check,num_check;
    
    myIOD10.output();
    myIOD10.write(0);
    wait(0.020f);
    
    myIOD10.write(1);
    wait(0.00002f);
    myIOD10.write(1);
    
    myIOD10.input();
    if(!myIOD10.read())
    {
        while(!myIOD10.read());
        while(myIOD10.read());
        R_H=receiveByte();
        R_L=receiveByte();
        T_H=receiveByte();
        T_L=receiveByte();
        check=receiveByte();
        wait(0.00004f);
        num_check=R_H+R_L+T_H+T_L;
        if(num_check==check)
        {
            RH=R_H;
            RL=R_L;
            TH=T_H;
            TL=T_L;
            check=num_check;
        }
    }
    
    receiveDht11Timeout.attach(&receiveDht11,0.2f);
}