#include "mbed.h"
#include "KrsServo.h"
#include "SerialHalfDuplex.h"

//通信失敗した場合の試行回数
#define MAXTRY 5

KrsServo::KrsServo(PinName tx,PinName rx,int id,int baudrate):ics(tx,rx)
{
    ics.baud(baudrate);
    _servoID = id;
}

bool KrsServo::write(unsigned char *txData,int txLen,unsigned char *rxData,int rxLen)
{
    int rxSize;//受信した数

    for (int i = 0; i< txLen; i++) {
        ics.putc(txData[i]);
    }
    wait(0.05);
    for (int i = 0; i< rxLen; i++) {
        //if(ics.readable()) {
            rxData[i]= ics.getc();
            rxSize++;
        //}
    }

    //受信数確認
    if (rxSize != rxLen) {
        return false;
    }
    return true;
}

int KrsServo::setPosition(int postion)
{
    //コマンドの成否
    bool exit_status;

    int txLen = 3;
    unsigned char txData[txLen];
    int rxLen = 3;
    unsigned char rxData[rxLen];
    int data;

    txData[0] = 0x80 | _servoID;
    txData[1] = (unsigned char)(postion >> 7 & 0x7F);
    txData[2] = (unsigned char)(postion & 0x7F);

    exit_status= write(txData,txLen,rxData,rxLen);

    data = (int)(rxData[1] & 0x7F);
    data = (data << 7) + (int)rxData[2];

    return data;
}

int KrsServo::setFree()
{
    return setPosition(0);
}

int KrsServo::setAngle(float deg)
{
    return setPosition(deg2pos(deg));
}

int KrsServo::getPosition()
{
    //コマンドの成否
    bool exit_status;

    int txLen = 3;
    unsigned char txData[txLen];
    int rxLen = 3;
    unsigned char rxData[rxLen];
    int data;

    exit_status = write(txData,txLen,rxData,rxLen);

    data = (int)(rxData[2] & 0x7F);
    data = (data << 7) + (int)rxData[3];

    return data;
}

int KrsServo::setSpeed(unsigned int speed)
{
    bool exit_status;

    int txLen = 3;
    unsigned char txData[txLen];
    int rxLen = 3;
    unsigned char rxData[rxLen];
    int data;
    
    txData[0] = 0xC0 + _servoID;      // CMD
    txData[1] = 0x02;           // SC スピード
    txData[2] = speed;            // スピード

    exit_status = write(txData,txLen,rxData,rxLen);

    data = rxData[2];

    return data;
}

float KrsServo::pos2deg(int pos)
{
    pos = pos - 7500;
    float deg = pos  / 29.633;

    return deg;
}

int KrsServo::deg2pos(float deg)
{

    int pos = deg * 29.633;
    pos = pos + 7500;
    return pos;
}