// LSM6DS3 Demo

#include "mbed.h"
#include "LSM6DS3.h"

// refresh time. set to 500 for part 2 and 50 for part 4
#define REFRESH_TIME_MS 1000

// Verify that the pin assignments below match your breadboard
LSM6DS3 imu(p30, p7);

Serial pc(p9, p11);

//Init Serial port and LSM6DS3 chip
void setup()
{
    // Use the begin() function to initialize the LSM9DS0 library.
    // You can either call it with no parameters (the easy way):
    // SLEEP
    //uint16_t status = imu.begin(imu.G_SCALE_245DPS, imu.A_SCALE_2G,
//                                imu.G_POWER_DOWN, imu.A_POWER_DOWN);
    // LOWEST
    //uint16_t status = imu.begin(imu.G_SCALE_245DPS, imu.A_SCALE_2G,
//                                imu.G_ODR_13_BW_0, imu.A_ODR_13);
    // HIGHEST
    uint16_t status = imu.begin(imu.G_SCALE_2000DPS, imu.A_SCALE_8G,
                                imu.G_ODR_1660, imu.A_ODR_6660);

    //Make sure communication is working
    pc.printf("LSM6DS3 WHO_AM_I's returned: 0x%X\r\n", status);
    pc.printf("Should be 0x69\r\n");
}

int main()
{
    setup();  //Setup sensor and Serial
    pc.printf("\r\n------ LSM6DS3 Demo -----------\r\n");

    while (true)
    {
        imu.readTemp();
        pc.printf("Temp:\r\n");
        pc.printf("TC: %2f\r\n", imu.temperature_c);
        pc.printf("TF: %2f\r\n", imu.temperature_f);
        
        imu.readAccel();
        pc.printf("Accel:\r\n");
        pc.printf("AX: %2f\r\n", imu.ax);
        pc.printf("AY: %2f\r\n", imu.ay);
        pc.printf("AZ: %2f\r\n", imu.az);

        imu.readGyro();
        pc.printf("Gyro:\r\n");
        pc.printf("GX: %2f\r\n", imu.gx);
        pc.printf("GY: %2f\r\n", imu.gy);
        pc.printf("GZ: %2f\r\n\r\n", imu.gz);
       
        wait_ms(REFRESH_TIME_MS);
    }
}
