// BNO055 Demo

#include "mbed.h"
#include "BNO055.h"

//Serial pc(USBTX, USBRX);
Serial pc(p9, p11);
//BNO055 imu(I2C_SDA,I2C_SCL);
BNO055 imu(p30, p7);

void setup() {
    pc.baud(115200);
    
    pc.printf("\r\n------ BNO055 Demo -----------\r\n");
      
    // Reset the BNO055
    imu.reset();
    // Check that the BNO055 is connected and display info
    if (imu.check())
    {
        pc.printf("BNO055 found\r\n\r\n");
        pc.printf("Chip          ID: %d\r\n",imu.ID.id);
        pc.printf("Accelerometer ID: %d\r\n",imu.ID.accel);
        pc.printf("Gyroscope     ID: %d\r\n",imu.ID.gyro);
        pc.printf("Magnetometer  ID: %d\r\n\r\n",imu.ID.mag);
        pc.printf("Firmware version v%d.%0d\r\n",imu.ID.sw[0],imu.ID.sw[1]);
        pc.printf("Bootloader version v%d\r\n\r\n",imu.ID.bootload);
    }
    
    // Set power mode, POWER_MODE_NORMAL(default), POWER_MODE_LOWPOWER, or POWER_MODE_SUSPEND(sleep)
    // By default, I2C will pull high when bus is free(pg90 of datasheet)
    imu.setpowermode(POWER_MODE_SUSPEND);
}

int main() {
    setup();
    
    while (true) {
        imu.setmode(OPERATION_MODE_AMG);
        pc.printf("Temp:\r\n");
        imu.set_temp_units(CENTIGRADE);
        imu.get_temp();
        pc.printf("TC: %d\r\n", imu.temperature);
        imu.set_temp_units(FAHRENHEIT);
        imu.get_temp();
        pc.printf("TF: %d\r\n", imu.temperature);
        
        imu.get_accel();
        pc.printf("Accel:\r\n");
        pc.printf("AX: %2f\r\n", imu.accel.x);
        pc.printf("AY: %2f\r\n", imu.accel.y);
        pc.printf("AZ: %2f\r\n", imu.accel.z);
        
        imu.get_gyro();
        pc.printf("Gyro:\r\n");
        pc.printf("GX: %2f\r\n", imu.gyro.x);
        pc.printf("GY: %2f\r\n", imu.gyro.y);
        pc.printf("GZ: %2f\r\n", imu.gyro.z);
        
        imu.get_mag();
        pc.printf("Mag:\r\n");
        pc.printf("MX: %2f\r\n", imu.mag.x);
        pc.printf("MY: %2f\r\n", imu.mag.y);
        pc.printf("MZ: %2f\r\n\r\n", imu.mag.z);
        
        wait(1.0);
    }
}
