/*
Modified by COX
version 0.1
 
Editor     : COX
Date       : 06.03.2013
 
*
* Update DFRobot source to work on FRDM KL25Z
*
*/
 
#include "LCD4884.h"
#include "font_6x8.h"
#include "font_big.h"
#include "mbed.h" 
#include <SPI.h>

DigitalOut SpiClk(D2);    //2- Serial Clock(Master Output)
DigitalOut SpiMosi(D3);  //3- Master Output,Slave Input
DigitalOut LcdDC(D4);      //4- Data/Command(command active low)
DigitalOut SpiCS(D5);      //5- Chip Select,Slave Transmit Enable(active low,Master Output)
DigitalOut LcdRst(D6);    //6- One Reset button
PwmOut     LcdBl(D7);      //7- LCD backlight
 
LCD4884::LCD4884()  
{};

/********************************************************************/
void LCD4884::backlight(float dat)
{
    LcdBl = dat;
}
/********************************************************************/
void LCD4884::LCD_write_byte(unsigned char dat, unsigned char dat_type)
{
    unsigned int i;
    SpiCS = 0; //Chip Enable:Active LOW
    unsigned char compare[8] = {0x01,0x02,0x04,0x08,0x10,0x20,0x40,0x80};
    
    if (dat_type == 0)
        LcdDC = 0; // D/C=0:the current data byte is interpreted as command byte
    else
        LcdDC = 1; // D/C=1:write data to display RAM
    
    
    for(i=0;i<8;i++)  {
        if(dat&compare[7-i]) 
        {
            SpiMosi = 1;
        }
        else
        {
            SpiMosi = 0;
        }
        SpiClk = 0;
        
        SpiClk = 1;
    }
    SpiCS = 1;
    //printf("a\n");
}
/********************************************************************/
void LCD4884::LCD_write_char(unsigned char c, char mode)
{
    unsigned char line;
    unsigned char *pFont;
    unsigned char ch; 
    
    pFont = (unsigned char *)font6_8; //pointer *pFont points at font6_8[][6]
    c -= 32; // the ASCII of "SP" is 32
 
    for (line=0; line<6; line++)
    {
        ch = *(pFont+c*6+line); //read c from the font6_8[][6] (the detail information is in the "font6x8.h")
        LCD_write_byte((mode==MENU_NORMAL)? ch:(ch^ 0xff), 1); //MENU_NORMAL=0,True:return ch;False:return ch
    }
}
/********************************************************************/
void LCD4884::LCD_set_XY(unsigned char X, unsigned char Y)
{
    LCD_write_byte(0x40 | Y, 0);        // column
    LCD_write_byte(0x80 | X, 0);        // row
}
/********************************************************************/
void LCD4884::LCD_clear(void)
{
    unsigned int i;
 
    LCD_write_byte(0x0c, 0);
    LCD_write_byte(0x80, 0);
 
    for (i=0; i<504; i++)  //6*84
    {
        LCD_write_byte(0, 1);
    }
}
/********************************************************************/
void LCD4884::LCD_init(void)
{
    /* pin intializer */
    SpiClk = LOW;
    SpiMosi = LOW;
    SpiCS = LOW;
    LcdDC = LOW;
    LcdBl = LOW;
 
    LcdRst = LOW;
    wait(ONE_US);
    LcdRst = HIGH;
    
    SpiCS = LOW;  //Chip Select, Slave Transmit Enable(active low, Master Output)
    wait(ONE_US);
    SpiCS = HIGH;
    wait(ONE_US);
    LcdBl = LCD_INITIAL_BRIGHTNESS;
    
    //data_type=0, all are command bytes
    LCD_write_byte(0x21, 0); //Function Set:0 0 1 0 0 PD V H=0010 0001;PD=0,V=0,H=1;
    LCD_write_byte(0xc0, 0); //Set Vop:1 Vop6 Vop5 Vop4 Vop3 Vop2 Vop1 Vop0=1100 0000
    LCD_write_byte(0x06, 0); //Set Temperature Coefficient:0 0 0 0 0 1 Tc1 Tc0=0000 0110;Tc1=1,Tc0=0(Vlcd temperature coefficient 2)
    LCD_write_byte(0x13, 0); //Set Bias System (BSx):0 0 0 1 0 BS2 BS1 BS0=0001 0011;BS2=0, BS1=1, BS0=1==>N=4,MUX RATE=1:48
 
    LCD_write_byte(0x20, 0);//Function Set:0 0 1 0 0 PD V H=0010 0000;PD=0,V=0,H=0;
    LCD_clear();
    LCD_write_byte(0x0c, 0);//Display Control: 0 0 0 0 1 D 0 E=0000 1100 ;D=1,E=0:normal mode
 
    SpiCS = LOW;
}
/********************************************************************/
void LCD4884::LCD_write_string(unsigned char X,unsigned char Y,char *s, char mode)
{
    LCD_set_XY(X,Y);
    while (*s)
    {
        LCD_write_char(*s, mode);
        s++;
    }
}
/********************************************************************/
void LCD4884::LCD_pixel(unsigned char X, unsigned char Y, char mode)
{
    unsigned char line=0; 
    unsigned char offset=0;
    unsigned char Pix=0;
    if(X>83) X = X%83;
    if(Y>47) Y = Y%47;
    line = Y/8;     
    offset = Y%8;
    
    switch(offset){
        case 0: Pix = 0x01; break;
        case 1: Pix = 0x02; break;
        case 2: Pix = 0x04; break;
        case 3: Pix = 0x08; break;
        case 4: Pix = 0x10; break;
        case 5: Pix = 0x20; break;
        case 6: Pix = 0x40; break;
        case 7: Pix = 0x80; break;
        }
    
    LCD_set_XY(X,line);    
    LCD_write_byte(Pix,1);
    printf("%d %d %d\n",X,line,Pix);
    wait_ms(10);
}