#include "mbed.h"
#include "WiflyInterface.h"
#include "HTTPClient.h"
#include <vector>
#include "SD.h"

WiflyInterface wifly(p13, p14, p29, p30, "GTother", "GeorgeP@1927", WPA);

HTTPClient http;
char str[512];

void setupWiFi()
{
    printf("trying to connect");
    wifly.init();
    while (!wifly.connect()) wait (0.1);
    printf("IP Address is %s\n\r", wifly.getIPAddress());
}

vector<robotCommand>* getTagCommands(int tagID)
{    
    vector<robotCommand>* commandVector = new vector<robotCommand>();
    printLCD("Translating", "Web Server");
    char url[512];
    char str[512];
    sprintf(url, "http://sabacai.com/index.php?tag=%d", tagID);
    printf("url is %s", url);
    int ret = http.get(url, str, 512);
    if (!ret) {
        printf("Tag String Received - read %d characters\n", strlen(str));
        str[strlen(str)-1] = '\0'; // remove the last column
        printf("Result: %s\n", str);
    }
    
    char * pch;
    printf ("Splitting string \"%s\" into tokens:\n",str);
    pch = strtok (str,",");
    
    int i = 0;
    CommandType commandID = None;
    
    while (pch != NULL)
    {
        printf ("%s\n",pch);
        double magnitude = 0.0;
        
        if ((i&0x1) == 0)
        {
            // this is the command type
            if (strcmp(pch, "FORWARD") == 0)
                commandID = Forward;
            else if (strcmp(pch, "REVERSE") == 0)
                commandID = Reverse; 
            else if (strcmp(pch, "LEFT") == 0)
                commandID = Left; 
            else if (strcmp(pch, "RIGHT") == 0)
                commandID = Right; 
            else if (strcmp(pch, "PLAYSOUND") == 0)
                commandID = PlaySound; 
                
            printf("command name is %s, id is %d", pch, commandID);
        }
        else 
        {
            // this is the magnitude
            magnitude = atof(pch);
            printf("magnitude is %f", magnitude);
        }
        
        // do some stuff here
        if (i != 0 && ((i&0x1) == 1))
        {
            // add the command to the vector
            printf(" now adding %d, %f", commandID, magnitude);
            commandVector->push_back(robotCommand(commandID, magnitude));
        }
        i+=1;
        pch = strtok (NULL, ",");
    }
    
    return commandVector;
}