#include "robot.h"

void initializeRobot() {
    printLCD("Initializing", NULL);
    // wait for Roomba to power up to accept serial commands
    wait(2);
    // set baud rate for Roomba factory default
    device.baud(57600);
    // Start command mode and select sensor data to send back
    start();
    
    //define songs
    //one beep
    device.printf("%c%c%c%c%c", Song, char(1), char(1), char(69), char(16));
    wait(1);
    //georgia tech fight song, split into 3 songs because max song length is 16
    device.printf("%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c", Song, char(2), char(16), char(67), char(18), char(0), char(2), char(65), char(9), char(0), char(2), char(63), char(18), char(0), char(2), char(63), char(9), char(0), char(2), char(63), char(18), char(0), char(2), char(65), char(9), char(0), char(2), char(67), char(18), char(0), char(2), char(67), char(9), char(0), char(2));
    device.printf("%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c", Song, char(14), char(16), char(67), char(9), char(0), char(2), char(65), char(9), char(0), char(2), char(63), char(9), char(0), char(2), char(65), char(9), char(0), char(2), char(65), char(9), char(0), char(2), char(65), char(9), char(0), char(2), char(63), char(18), char(0), char(2), char(62), char(9), char(63), char(54));
    //a major arpeggio
    device.printf("%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c", Song, char(3), char(7), char(69), char(32), char(73), char(32), char(76), char(32), char(81), char(32), char(76), char(32), char(73), char(32), char(69), char(32));
    clearLCD();
}

// Start  - send start and safe mode, start streaming sensor data
void start() {
   // device.printf("%c%c", Start, SafeMode);
    device.putc(Start);
    wait(.1);
    device.putc(Control);
    wait(.5);
  //  device.printf("%c%c", SensorStream, char(1));
    device.putc(Sensors);
    device.putc(BumpsandDrops);
    wait(.5);
}
// Stop  - turn off drive motors
void stop() {
    device.printf("%c%c%c%c%c", Drive, char(0),  char(0),  char(0),  char(0));
}
// Forward  - turn on drive motors
void forward() {
    device.printf("%c%c%c%c%c", Drive, char((speed>>8)&0xFF),  char(speed&0xFF),  
    char((radius>>8)&0xFF),  char(radius&0xFF));
 
}
// Reverse - reverse drive motors
void reverse() {
    device.printf("%c%c%c%c%c", Drive, char(((-speed)>>8)&0xFF),  char((-speed)&0xFF),  
    char(((radius)>>8)&0xFF),  char((radius)&0xFF));
 
}
// Left - drive motors set to rotate to left
void left() {
    device.printf("%c%c%c%c%c", Drive, char((speed>>8)&0xFF),  char(speed&0xFF),  
    char(((1)>>8)&0xFF),  char((1)&0xFF));
}
// Right - drive motors set to rotate to right
void right() {
    device.printf("%c%c%c%c%c", Drive, char(((speed)>>8)&0xFF),  char((speed)&0xFF),  
    char((-1>>8)&0xFF),  char(-1&0xFF));
 
}
// Charger - search and return to charger using IR beacons (if found)
void charger() {
    device.printf("%c", Clean );
    wait(.2);
    device.printf("%c", CoverandDock );
}
// Play Song  - play a song
void playsong(int mag) { //Play song
    if(mag == 2) { //play rest of georgia tech fight song
        device.printf("%c%c%c%c%c%c%c%c", NewScript, char(6), PlaySong, char(2), WaitTime, char(20), PlaySong, char(14));
        device.printf("%c", DoScript);
    }
    else {
        device.printf("%c%c", PlaySong, char(mag));
    }
}