#ifndef _DRIVER_H
#define _DRIVER_H

#include "mbed.h"
#include "LCDText.h"
#include "DebounceIn.h"
#include "robot.h"
#include "ID12RFID.h"
#include "RFID.h"
#include "SD.h"

DigitalOut myled1(LED1), myled2(LED2), myled3(LED3), myled4(LED4);
Serial device(p28, p27);
TextLCD mylcd(p15, p16, p17, p18, p19, p20);
DebounceIn down(p22), up(p23), select(p24), back(p21);
ID12RFID rfid(p10); // uart rx
SDFileSystem sd(p5, p6, p7, p8, "sd");

void processCommands(vector<robotCommand> &commands);
void initialize();

#endif