#ifndef _SD_H
#define _SD_H

#include "mbed.h"
#include "SDFileSystem.h"
#include "iniparser.h"
#include "dictionary.h"
#include <vector>
#include "LCDText.h"

typedef enum {
    Forward,
    Reverse,
    Left,
    Right,
    PlaySound,
    None
} CommandType; 

class robotCommand {
public:
    robotCommand(CommandType type, double mag) : commandType(type), magnitude(mag) {}
    CommandType commandType;
    double magnitude;
};

extern SDFileSystem sd;

void setupSDCard();
vector<robotCommand>* translateTags(vector<int>& tagValues);
vector<robotCommand>* getProgrammedPath(int pathNumber);
void writeTagCommand(int tagID, CommandType value);
void writeTagCommand(int tagID, double magValue);

#endif