#include "SD.h"

dictionary* translationFile;
dictionary* programmedFile;

void setupSDCard()
{
    translationFile = iniparser_load("/sd/translationFile.ini");
    programmedFile = iniparser_load("/sd/programmedFile.ini");
    
    if(translationFile && programmedFile) {
        printLCD("Files opened", "succesfully!");
    }
    else if(!translationFile && !programmedFile) {
        printLCD("Error opening", "both files");
    }
    else if(!translationFile) {
        printLCD("Error opening", "translation");
    }
    else {
        printLCD("Error opening", "programmed");
    }
    wait(1.5);
}

vector<robotCommand>* translateTags(vector<int>& tagValues)
{

    vector<robotCommand>* commandVector = new vector<robotCommand>();
    printLCD("Translating", NULL);
    wait(.5);
    
    for (int i = 0; i < tagValues.size(); i += 2) // Tags alternate between command type and magnitude
    {
        printf("trying to find tag # %d\n", tagValues[i]);
        char tagName[40];
        sprintf(tagName, "translations:%d", tagValues[i]%1000);
        
        // get the command string from the ini file
        
        char commandName[30];
        sprintf(commandName,"%s", iniparser_getstring(translationFile,tagName, "NONE"));

        //printf("commandName is: %s\n", commandName);
        CommandType commandID = None;
        
        if (strcmp(commandName, "FORWARD") == 0)
            commandID = Forward;
        else if (strcmp(commandName, "REVERSE") == 0)
            commandID = Reverse; 
        else if (strcmp(commandName, "LEFT") == 0)
            commandID = Left; 
        else if (strcmp(commandName, "RIGHT") == 0)
            commandID = Right; 
        else if (strcmp(commandName, "PLAYSOUND") == 0)
            commandID = PlaySound; 
        
        sprintf(tagName, "Translations:%d", tagValues[i+1]%1000);
        double magnitude = iniparser_getdouble(translationFile,tagName, 0.0);
        printf("Adding %d %f", commandID, magnitude);
        commandVector->push_back(robotCommand(commandID, magnitude));
    }
    printf("done searching\n");
    printLCD("Translation", "Complete");
    wait(.5);
    return commandVector;
}

vector<robotCommand>* getProgrammedPath(int pathNumber)
{
    vector<robotCommand>* commandVector = new vector<robotCommand>();
    printLCD("Translating", NULL);
    wait(.5);
    
    char sectionName[30];
    sprintf(sectionName, "path%d", pathNumber);
    printf("section name: %s\n", sectionName);
    int num_keys = iniparser_getsecnkeys(programmedFile, sectionName);
    
    printf("number of keys: %d\n", num_keys);
    char keyName[5];
    for (int i = 0; i < num_keys; i+= 2)
    {
        sprintf(keyName,"path%d:%d",pathNumber, i);
        char commandName[30];
        sprintf(commandName,"%s", iniparser_getstring(programmedFile,keyName, "NONE"));
 
        CommandType commandID = None;
        if (strcmp(commandName, "FORWARD") == 0)
            commandID = Forward;
        else if (strcmp(commandName, "REVERSE") == 0)
            commandID = Reverse; 
        else if (strcmp(commandName, "LEFT") == 0)
            commandID = Left; 
        else if (strcmp(commandName, "RIGHT") == 0)
            commandID = Right; 
        else if (strcmp(commandName, "PLAYSOUND") == 0)
            commandID = PlaySound; 
            
        sprintf(keyName,"path%d:%d",pathNumber, i+1);
        double magnitude = iniparser_getdouble(programmedFile,keyName, 0.0);
        printf("Adding %d %f", commandID, magnitude);
        commandVector->push_back(robotCommand(commandID, magnitude));
    }
    printf("done searching pre-programmed path\n");
    printLCD("Translation", "Complete");
    wait(.5);
    return commandVector;
}

void writeTagCommand(int tagID, CommandType value)
{
    printf("first key: %s\n", translationFile->key[1]);
    printf("Entering Write Command, tagID: %d, value: %d\n", tagID, value);
    char stringValue[15];
    tagID = tagID % 1000;
    
    if (value == 0)
    {
        sprintf(stringValue, "FORWARD");
    }
    else if (value == 1)
    {
        sprintf(stringValue, "REVERSE");
    }
    else if (value == 2)
    {
        sprintf(stringValue, "LEFT");
    }
    else if (value == 3)
    {
        sprintf(stringValue, "RIGHT");
    }
    else if (value == 4)
    {
        sprintf(stringValue, "PLAYSOUND");
    }

    char keyName[30];
    sprintf(keyName, "translations:%d", tagID);
    printf("trying to set\n");
    int val = dictionary_set(translationFile, keyName, stringValue);
    
    
    FILE* translationFilePointer = fopen("/sd/translationFile.ini", "w"); // need to make sure this is right
    if (translationFilePointer != NULL) printf("file opened succesfully\n");
    iniparser_dump(translationFile, translationFilePointer);
    printf("done dumping\n");
    printf("value is now %s\n", iniparser_getstring(translationFile,keyName, "NONE"));
    fclose(translationFilePointer);
    printLCD("Tag Updated", NULL);
    wait(1.5);
}

void writeTagCommand(int tagID, double magValue)
{
    char keyName[30];
    tagID = tagID % 1000;
    sprintf(keyName, "translations:%d", tagID); // need to make sure this is right
    
    char stringValue[20];
    sprintf(stringValue, "%f", magValue);
    
    dictionary_set(translationFile, keyName, stringValue); // add the key to the dictionary
    FILE* translationFilePointer = fopen("/sd/translationFile.ini", "w");
    iniparser_dump_ini(translationFile, translationFilePointer);
    fclose(translationFilePointer);
    printLCD("Tag Updated", NULL);
    wait(1.5);
}


