#ifndef _ROBOT_H
#define _ROBOT_H

#include "mbed.h"
#include <vector>
#include "LCDText.h"

extern Serial device;
 
// Definitions of iRobot Roomba SCI Command Numbers
// See the Roomba SCI manual for a complete list
 
 
//                 Create Command              // Arguments
const char         Start = 128;
const char         Control = 130;
const char         FullMode = 132;
const char         Drive = 137;                // 4:   [Vel. Hi] [Vel Low] [Rad. Hi] [Rad. Low]
const char         Sensors = 142;              // 1:    Sensor Packet ID
const char         CoverandDock = 143;         // 0:    Return to Charger
const char         Clean = 135;                 // 0:    Start Cleaning
const char         PlaySong = 141;
const char         Song = 140;
const char         NewScript = 152;
const char         DoScript = 153;
const char         WaitTime = 155;
const char         WaitAngle = 157;
                /* iRobot Roomba Sensor IDs */
const char         BumpsandDrops = 1;
 
const int speed =  250;
const int radius = 0x8000;
void start();
void forward();
void reverse();
void left();
void right();
void stop();
void playsong(int mag);
void charger();
void initializeRobot();

#endif