#include "LCDText.h"

void clearLCD() {
    char buff[33];
    memset(buff, ' ', 32);
    buff[32] = '\0';
    mylcd.printf(buff);
}

//clears LCD and prints the two strings centered on each line
//max length of each string is 16
void printLCD(const char* string1, const char* string2) {
    char buff[33];
    memset(buff, ' ', 32);
    buff[32] = '\0';
    //clear LCD
    clearLCD();
    
    //print to LCD
    if(string1) {
        memcpy(buff+(16-strlen(string1))/2, string1, strlen(string1));
    }
    if(string2) {
        memcpy(buff+16+(16-strlen(string2))/2, string2, strlen(string2));
    }
    mylcd.printf(buff);
}

//creates a menu with with a title, controlled by the up/down/select buttons
//returns index of option selected
int displayMenu(const char* menuTitle, const char** menuOptions, int numOptions) {
    int curSelection = 0;
    
    printLCD(menuTitle, menuOptions[curSelection]);
    if(!up || !down || !select || !back) wait(.3);
    while(1) {
        if(!up) {
            curSelection = (curSelection == numOptions-1) ? 0 : (curSelection + 1);
            printLCD(menuTitle, menuOptions[curSelection]);
            if(!up) wait(.2);
        }
        if(!down) {
            curSelection = (curSelection == 0) ? (numOptions - 1) : (curSelection - 1);
            printLCD(menuTitle, menuOptions[curSelection]);
            if(!down) wait(.2);
        }
        if(!select) {
            clearLCD();
            return curSelection;
        }
        if(!back) {
            clearLCD();
            return -1;
        }
    }
}
