#include "mbed.h"
#include "EthernetNetIf.h"
#include "HTTPClient.h"
#include "GPS.h"

EthernetNetIf eth;
GPS gps(p13, p14);

int main() {
    // Setup the time structure   
    char buff[141];

    printf("Initialization in Process\n");
    
    EthernetErr ethErr = eth.setup(60000);
    if(ethErr)
    {
        printf("Error %d in setup.\n", ethErr);
        return -1;
    }
    printf("\r\nSetup OK\r\n");
    
    // Setup objects for sending the tweet.
    HTTPClient twitter;
    HTTPMap msg;
    
    while(1) {
        
        printf("\Attempting to Read in From the GPS Device\n\r");
        gps.sample();
        if(gps.sample()) {
            printf("I'm at %f, %f\n\r",  gps.longitude, gps.latitude);
            sprintf(buff,"I'm at %f, %f",  gps.longitude, gps.latitude);
        } else {
            printf("Oh Dear! No lock :(\n\r");
            sprintf(buff,"Location Unknown");
            }
        }
        
        msg["status"] = buff;
        twitter.basicAuth("username", "password"); //We use basic authentication, replace with you account's parameters

        //No need to retieve data sent back by the server
        HTTPResult r = twitter.post("http://api.supertweet.net/1.1/statuses/update.json", msg, NULL); 
        if( r == HTTP_OK )
        {
          printf("Tweet sent with success!\n");
        }
        else
        {
          printf("Problem during tweeting, return code %d\n", r);
        }
        
        wait(60*5); //Repeat ever 5 minutes
    }
    
    return 0;

}
