#include "mbed.h"
#include "EthernetNetIf.h"
#include "HTTPClient.h"
#include "spdomparser.hpp"
#include "spxmlnode.hpp"
#include "spxmlhandle.hpp"
#include "NokiaLCD.h"
// Internet of Things weather display example: LCD displays LA current weather via internet Google API
// Adapted for LCD from http://mbed.org/users/hlipka/programs/spxmltest_weather/lif782

NokiaLCD lcd(p5, p7, p8, p9, NokiaLCD::LCD6610); // mosi, sclk, cs, rst, type
EthernetNetIf eth;
HTTPClient http;
HTTPResult result;
bool completed = false;
void request_callback(HTTPResult r) {
    result = r;
    completed = true;
}

void parseWeather(SP_XmlElementNode *node) {
    //extracts current weather XML data fields for LCD
    SP_XmlHandle handle(node);
    SP_XmlElementNode * condition = handle.getChild( "condition" ).toElement();
    lcd.cls();
    lcd.locate(0,2);
    lcd.printf("LA:");
    if (condition) {
        lcd.printf("%s ",condition->getAttrValue("data"));
    }
    SP_XmlElementNode * tempf = handle.getChild( "temp_f" ).toElement();
    if (tempf) {
        lcd.printf(" %sF",tempf->getAttrValue("data"));
    }
    SP_XmlElementNode * humidity = handle.getChild( "humidity" ).toElement();
    if (humidity) {
        lcd.locate(0,3);
        lcd.printf("%s",humidity->getAttrValue("data"));
    }
}

int main() {
    // the eth and HTTP code has be taken directly from the HTTPStream documentation page
    // see http://mbed.org/cookbook/HTTP-Client-Data-Containers
    lcd.cls();
    lcd.locate(0,2);
    lcd.printf("net setup");
    lcd.locate(0,3);
    EthernetErr ethErr = eth.setup();
    if (ethErr) {
        lcd.printf("Error in setup");
        return -1;
    }
    lcd.printf("net ok");

    SP_XmlDomParser parser;
    HTTPStream stream;

    char BigBuf[512 + 1] = {0};
    stream.readNext((byte*)BigBuf, 512); //Point to buffer for the first read
    //Google Weather API for Los Angeles - get web page with XML
    HTTPResult r = http.get("http://www.google.com/ig/api?weather=Los+Angeles", &stream, request_callback);
    while (!completed) {
        Net::poll(); //Polls the Networking stack
        if (stream.readable()) {
            BigBuf[stream.readLen()] = 0; //Transform this buffer in a zero-terminated char* string
            parser.append( BigBuf, strlen(BigBuf)); // stream current buffer data to the XML parser
            stream.readNext((byte*)BigBuf, 512); //Buffer has been read, now we can put more data in it
        }
    }
    lcd.cls();
    lcd.locate(0,2);
    if (result == HTTP_OK) {
        lcd.printf(" Read complete");
    } else {
        lcd. printf(" Error %d", result);
        return -1;
    }

    SP_XmlHandle rootHandle( parser.getDocument()->getRootElement() );
    SP_XmlElementNode * child2 = rootHandle.getChild( "weather" )
                                 .getChild( "current_conditions").toElement();
    if ( child2 ) {
        parseWeather(child2); //parses XML "current-conditions" info
    }

    if ( NULL != parser.getError() ) {
        lcd.printf( "\n error: %s\n", parser.getError() );
    }
}
