#include "mbed.h"
// Waveplayer Helloworld for mbed LP1768 running mbed OS 5
// NOTE: Need "target.components_add": ["SD"] in json project file!
// This adds the filesystem driver below for SD cards in an OS 5 project
// See https://os.mbed.com/users/4180_1/notebook/using-a-speaker-for-audio-output/
// for additional details
#include "SDBlockDevice.h"
#include "FATFileSystem.h"
#include "wave_player.h"

// LED Components
PwmOut led(LED1);
DigitalOut led4(LED4);

// SD File System Components
SDBlockDevice   sd(p5, p6, p7, p8);
FATFileSystem   fs("sd");

// Audio Components
AnalogOut       dac(p18);
PwmOut          speaker(p25);
//outputs audio to both DAC and PWM pin
//select one to drive speaker
wave_player     wav(&dac, &speaker);

Thread led_thread, audio_thread;

void led_siren()
{
    const int build_time = 100;
    while (1) {
        //LED warm up effect using PWM
        for(int i=0; i<build_time; i++) {
            led = i / (float) build_time;
            ThisThread::sleep_for(1000.0*0.02);
        }
        //LED at full brightness level
        led = 1.0;
        ThisThread::sleep_for(1000.0*0.25);
        //LED cool down effect using PWM
        for(int i=build_time-1; i>0; i--) {
            led = i/ (float) build_time;
            ThisThread::sleep_for(1000.0*0.02);
        }
        //LED off
        led = 0.0;
        ThisThread::sleep_for(1000.0*1.5);
    }
}

void play_audio()
{
    FILE * wav_file;
    speaker.period(1.0/400000.0); //increase PWM clock rate for audio
    sd.init();
    sd.frequency(25000000); //increase SPI clock rate for audio
    while (1) {
        fs.mount(&sd);
        //need sample.wav file on SD card
        //wave file format mono 16Khz or less (not mp3!)
        wav_file = fopen("/sd/sample.wav", "r");
        wav.play(wav_file);
        fclose(wav_file);
        fs.unmount();
        wait(1);
    }
}

// main() runs in its own thread in the OS
int main()
{
    led_thread.start(led_siren);
    audio_thread.start(play_audio);
    while (true) {
        ThisThread::sleep_for(500);
        led4 = !led4;
    }
}
