#include "mbed.h"

RawSerial  pc(USBTX, USBRX);
RawSerial  dev(p13,p14);
DigitalOut led1(LED1);
DigitalOut led4(LED4);

void dev_recv()
{
    led1 = !led1;
    while(dev.readable()) {
        pc.putc(dev.getc());
    }
}

void pc_recv()
{
    led4 = !led4;
    char x;
    while(pc.readable()) {
        x=pc.getc();
        dev.putc(x);
        pc.putc(x); //echo back so that you can see what you are typing!
    }
}

int main()
{
    pc.baud(9600);
    dev.baud(9600);

    pc.attach(&pc_recv, Serial::RxIrq);
    dev.attach(&dev_recv, Serial::RxIrq);

    while(1) {
        sleep();
    }
}
