#include "mbed.h"
#include "steam-train.h" //setup recorded sound data in flash
#include "steam-whistle.h"
//Mixes two sounds, steam engine and whistle,
//using flash audio player
//pushbutton on p12 blows whistle
//Speaker with amp on p18 DAC to play audio

AnalogOut speaker(p18);//output to audio amp to drive speaker
DigitalOut led(LED1);
DigitalOut led2(LED2);
DigitalIn whistle(p12,PullUp);//pushbutton to ground for whistle
Ticker audio_tick; //audio sample rate interrupt
int i=0;
int j=0;

//interrupt routine to play next audio sample from array in flash
void audio_sample ()
{
    unsigned short data;
    data = steam_train_data[i]>>1;
    //add whistle sound if button hit
    //since two audio signals are added, scaling down using >>1
    //(i.e., shift is faster than /2) avoids overflow (i.e., audio distortion)
    //As an alternative, data could also be scaled down
    //in the .h flash data files using the audio tools
    if (!whistle) {
        data = data+(steam_whistle_data[j]>>1);
        j++;
        if (j>NUM_ELEMENTS_WHISTLE) j=0;
    } else j=0;
    //scale down by 2 to avoid amp saturation and audio distortion
    speaker.write_u16(data);
    i++;
    if (i>NUM_ELEMENTS_TRAIN) i = 0;
}

int main()
{
    //enable audio interrupt using timer - 8Khz sample rate
    audio_tick.attach(&audio_sample, 1.0 / 8000.0);
    while(1) {
        //LED blink
        led = !led;
        //Whistle pb status
        led2 = !whistle;
        wait(0.5);
    }
}
