//Demo using additional SRAM Banks on LPC1768
#include "mbed.h"
Serial pc(USBTX,USBRX);
DigitalOut myled(LED1);
int i=0;
int buffer_SRAM[3000]; //regular SRAM use by compiler
int buffer_SRAM_Bank0[4000] __attribute__((section("AHBSRAM0"))); //put in extra 16K bank
int buffer_SRAM_Bank1[4000] __attribute__((section("AHBSRAM1"))); //put in other extra 16K bank
int main()
{
    pc.printf("Hello Extra SRAM\n\r");
    pc.printf("size of int %d bytes\n\r",sizeof(buffer_SRAM[0]));
    pc.printf("address of buffer_SRAM %x\n\r",buffer_SRAM);
    pc.printf("address of buffer_SRAM_Bank0 %x\n\r",buffer_SRAM_Bank0);
    pc.printf("address of buffer_SRAM_Bank1 %x\n\r",buffer_SRAM_Bank1);
    wait(5);
    while(1) {
        myled = 1;
        for(i=0; i<4000; i++) {
            buffer_SRAM_Bank0[i]=i;
        }
        for(i=0; i<4000; i++) {
            buffer_SRAM_Bank1[i]= -i;
        }
        for(i=0; i<3000; i++) {
            buffer_SRAM[i]= 0;
        }
        myled=0;
        for (i=0; i<4000; i++) {
            pc.printf("%d\n\r",buffer_SRAM_Bank0[i]);
        }
        for (i=0; i<4000; i++) {
            pc.printf("%d\n\r",buffer_SRAM_Bank1[i]);
        }
        for (i=0; i<3000; i++) {
            pc.printf("%d\n\r",buffer_SRAM[i]);
        }
        myled = 1;
    }
}
