#include "mbed.h"
// Retro version of kill the bit
// For application board
// Joystick push kills LED bit on left, if it is on
// If bit is not on, another is created
// Goal is to kill off all of the bits
// LEDs flash and speaker beeps on a win

DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);
DigitalOut myled4(LED4);
DigitalIn pb(p14);
PwmOut spkr(p26);

void display(int number)
{
    myled1 = (number) & 0x01;
    myled2 = (number>>1) & 0x01;
    myled3 = (number>>2) & 0x01;
    myled4 = (number>>3) & 0x01;
}
int main()
{
    unsigned int value = 0x12;
    spkr.period(1.0/2000.0);
    while(1) {
        value = value ^ pb;
        if (value == 0) {
            for (int i=0; i<5; ++i) {
                spkr = 0.5;
                display(0x0F);
                wait(.5);
                display(0);
                spkr = 0.0;
                wait(.25);
            }
            value = 0x012;
        }
        value = ((value & 0x01)<<3) | value >> 1;
        display(value);
        wait(.25);
    }
}
